/*
 * Decompiled with CFR 0.152.
 */
package com.macweese.clickminimaporb;

import com.google.inject.Provides;
import com.macweese.clickminimaporb.ClickMinimapOrbsConfig;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Click Minimap Orbs", description="Prevents clicking through the minimap orbs on resizable mode", tags={"minimap", "status", "orbs", "click", "through"}, conflicts={"ClickMinimapOrbsPlugin"})
public class ClickMinimapOrbsPlugin
extends Plugin {
    @Inject
    private ClickMinimapOrbsConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private static final int ENUM_SPEC_ITEM_MAP = 906;
    private static final int SCRIPT_UPDATE_HITPOINTS_ORB = 446;
    private static final int SCRIPT_UPDATE_SPEC_ORB = 2792;
    private Widget specOrbWidget;
    private Widget hitpointsOrbWidget;
    private boolean consumeSpecOrb;
    private boolean consumeHitpointsOrb;

    @Provides
    ClickMinimapOrbsConfig getConfig(ConfigManager configManager) {
        return (ClickMinimapOrbsConfig)configManager.getConfig(ClickMinimapOrbsConfig.class);
    }

    protected void startUp() {
        this.consumeSpecOrb = this.config.blockSpecialAttackOrb();
        this.consumeHitpointsOrb = this.config.blockHitpointsOrb();
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            this.specOrbWidget = this.client.getWidget(WidgetInfo.MINIMAP_SPEC_ORB).getStaticChildren()[1];
            this.hitpointsOrbWidget = this.client.getWidget(WidgetInfo.MINIMAP_HEALTH_ORB).getStaticChildren()[1];
            if (!this.client.isResized()) {
                return;
            }
            this.setSpecOrbConsuming(this.consumeSpecOrb);
            this.setHitpointsOrbConsuming(this.consumeHitpointsOrb);
        });
    }

    protected void shutDown() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            this.setSpecOrbConsuming(false);
            this.setHitpointsOrbConsuming(false);
        });
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equalsIgnoreCase("clickminimaporbs2d3a8ae")) {
            return;
        }
        this.consumeSpecOrb = this.config.blockSpecialAttackOrb();
        this.consumeHitpointsOrb = this.config.blockHitpointsOrb();
        this.clientThread.invokeLater(() -> {
            if (!this.client.isResized()) {
                return;
            }
            this.setSpecOrbConsuming(this.consumeSpecOrb);
            this.setHitpointsOrbConsuming(this.consumeHitpointsOrb);
        });
    }

    @Subscribe
    private void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() != 160) {
            return;
        }
        this.specOrbWidget = this.client.getWidget(WidgetInfo.MINIMAP_SPEC_ORB).getStaticChildren()[1];
        this.hitpointsOrbWidget = this.client.getWidget(WidgetInfo.MINIMAP_HEALTH_ORB).getStaticChildren()[1];
    }

    @Subscribe
    private void onScriptPostFired(ScriptPostFired event) {
        if (!this.client.isResized()) {
            return;
        }
        if (event.getScriptId() == 446) {
            boolean permeable;
            if (this.hitpointsOrbWidget == null) {
                this.hitpointsOrbWidget = this.client.getWidget(WidgetInfo.MINIMAP_HEALTH_ORB).getStaticChildren()[1];
            }
            boolean bl = permeable = this.hitpointsOrbWidget.isHidden() || !this.hitpointsOrbWidget.getNoClickThrough();
            if (permeable) {
                this.setHitpointsOrbConsuming(this.consumeHitpointsOrb);
            }
        } else if (event.getScriptId() == 2792) {
            boolean permeable;
            if (this.specOrbWidget == null) {
                this.specOrbWidget = this.client.getWidget(WidgetInfo.MINIMAP_SPEC_ORB).getStaticChildren()[1];
            }
            boolean bl = permeable = this.specOrbWidget.isHidden() || !this.specOrbWidget.getNoClickThrough();
            if (permeable) {
                this.setSpecOrbConsuming(this.consumeSpecOrb);
            }
        }
    }

    private boolean hasSpecialAttackItem() {
        ItemContainer equipmentContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipmentContainer == null) {
            return false;
        }
        Item[] items = this.client.getItemContainer(InventoryID.EQUIPMENT).getItems();
        return Arrays.stream(items).dropWhile(Objects::isNull).mapToInt(Item::getId).anyMatch(i -> Arrays.stream(this.client.getEnum(906).getKeys()).anyMatch(j -> i == j));
    }

    private boolean isDebilitated() {
        return this.client.getVarbitValue(10151) > 0 || this.client.getVarpValue(102) > 0 || this.client.getVarpValue(456) > 0;
    }

    private void setSpecOrbConsuming(boolean consume) {
        if (this.specOrbWidget == null) {
            return;
        }
        if (consume) {
            this.specOrbWidget.setNoClickThrough(this.consumeSpecOrb);
            this.specOrbWidget.setHidden(false);
        } else {
            this.specOrbWidget.setHidden(!this.hasSpecialAttackItem());
        }
    }

    private void setHitpointsOrbConsuming(boolean consume) {
        if (this.hitpointsOrbWidget == null) {
            return;
        }
        boolean isPoisonedOrDiseased = this.isDebilitated();
        if (consume) {
            this.hitpointsOrbWidget.setNoClickThrough(this.consumeHitpointsOrb);
            this.hitpointsOrbWidget.setHidden(false);
        } else {
            this.hitpointsOrbWidget.setNoClickThrough(isPoisonedOrDiseased);
            this.hitpointsOrbWidget.setHidden(!isPoisonedOrDiseased);
        }
    }
}

