/*
 * Decompiled with CFR 0.152.
 */
package com.stepcounter;

import com.google.inject.Provides;
import com.stepcounter.StepCounterConfig;
import com.stepcounter.StepCounterOverlay;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Step Counter")
public class StepCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StepCounterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private StepCounterConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private StepCounterOverlay overlay;
    private WorldPoint previousLocation;
    private int currentSteps;
    private int goal;
    private boolean firstLoad;
    private boolean congratulations;

    protected void startUp() throws Exception {
        this.previousLocation = new WorldPoint(0, 0, 0);
        this.currentSteps = 0;
        this.goal = this.config.StepGoal();
        this.overlayManager.add((Overlay)this.overlay);
        this.firstLoad = true;
        this.congratulations = false;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.firstLoad = true;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (this.firstLoad) {
            this.firstLoad = false;
            this.congratulations = false;
            this.goal = this.config.StepGoal();
            this.currentSteps = 0;
        }
    }

    private boolean areTheSameLocation(WorldPoint previous, WorldPoint current) {
        return previous.getX() == current.getX() && previous.getY() == current.getY();
    }

    private int distanceDelta(WorldPoint previousLocation, WorldPoint currentLocation) {
        int potentialDistance = Math.abs(previousLocation.getX() - currentLocation.getX()) + Math.abs(previousLocation.getY() - currentLocation.getY());
        if (potentialDistance > 100) {
            return 0;
        }
        return potentialDistance;
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        WorldPoint currentLocation;
        if (this.goal != this.config.StepGoal()) {
            this.goal = this.config.StepGoal();
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Step goal updated to " + this.goal + ".", null);
        }
        try {
            currentLocation = this.client.getLocalPlayer().getWorldLocation();
        }
        catch (NullPointerException e) {
            return;
        }
        if (!this.areTheSameLocation(this.previousLocation, currentLocation)) {
            int distanceTravelledThisTick = this.distanceDelta(this.previousLocation, currentLocation);
            this.previousLocation = currentLocation;
            this.currentSteps += distanceTravelledThisTick;
            if (this.currentSteps >= this.goal && !this.congratulations) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You hit your step goal! Congratulations!", null);
                this.congratulations = true;
            }
        }
    }

    @Provides
    StepCounterConfig provideConfig(ConfigManager configManager) {
        return (StepCounterConfig)configManager.getConfig(StepCounterConfig.class);
    }

    public int getSteps() {
        return this.currentSteps;
    }

    public int getGoal() {
        return this.goal;
    }
}

