/*
 * Decompiled with CFR 0.152.
 */
package com.stepcounter;

import com.stepcounter.StepCounterConfig;
import com.stepcounter.StepCounterPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class StepCounterOverlay
extends OverlayPanel {
    private final StepCounterConfig config;
    private final StepCounterPlugin plugin;

    @Inject
    StepCounterOverlay(StepCounterPlugin pluginIn, StepCounterConfig configIn) {
        super((Plugin)pluginIn);
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.config = configIn;
        this.plugin = pluginIn;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Keep Walking Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.ShowSteps()) {
            return null;
        }
        boolean goalComplete = this.plugin.getSteps() >= this.plugin.getGoal();
        String remainingSteps = this.plugin.getSteps() + " steps of " + this.plugin.getGoal() + " goal";
        this.panelComponent.getChildren().add(TitleComponent.builder().text(remainingSteps).color(goalComplete ? Color.GREEN : Color.WHITE).build());
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(remainingSteps) + 10, 0));
        return super.render(graphics);
    }
}

