/*
 * Decompiled with CFR 0.152.
 */
package com.gnomechildify;

import com.gnomechildify.GnomeChildifyConfig;
import com.google.inject.Provides;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Gnome Childify", description="Turn your friends into a gnome child for hilarious moments!")
public class GnomeChildifyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GnomeChildifyPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GnomeChildifyConfig config;

    @Provides
    GnomeChildifyConfig provideConfig(ConfigManager configManager) {
        return (GnomeChildifyConfig)configManager.getConfig(GnomeChildifyConfig.class);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.config.menuEntries() && this.client.isKeyPressed(81) && event.getType() == MenuAction.PLAYER_THIRD_OPTION.getId()) {
            this.client.createMenuEntry(-1).setOption(ColorUtil.prependColorTag((String)"Gnome Childify", (Color)Color.ORANGE)).setTarget(event.getTarget()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE_PLAYER);
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER && event.getMenuOption().contains("Gnome Childify")) {
            int id = event.getId();
            Player[] cachedPlayers = this.client.getCachedPlayers();
            Player player = cachedPlayers[id];
            if (player == null || player.getName() == null) {
                return;
            }
            PlayerComposition pc = player.getPlayerComposition();
            pc.setTransformedNpcId(6077);
        }
    }

    @Subscribe
    private void onPlayerSpawned(PlayerSpawned event) {
        Player player = event.getPlayer();
        if (player.getName() != null && player.getName().equalsIgnoreCase(this.config.rsn())) {
            PlayerComposition pc = player.getPlayerComposition();
            pc.setTransformedNpcId(6077);
        }
    }
}

