/*
 * Decompiled with CFR 0.152.
 */
package org.CustomDropsSounds;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.ChatMessageType;
import net.runelite.api.ItemComposition;
import net.runelite.api.TileItem;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.GroundItemsPlugin;
import net.runelite.client.util.Text;
import org.CustomDropsSounds.CustomDropSoundsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Custom Drop Sounds")
@PluginDependency(value=GroundItemsPlugin.class)
public class CustomDropSoundsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CustomDropSoundsPlugin.class);
    @Inject
    private CustomDropSoundsConfig config;
    @Inject
    private GroundItemsConfig groundItemsConfig;
    @Inject
    private ItemManager itemManager;
    private static final ImmutableList<String> PET_MESSAGES = ImmutableList.of((Object)"You have a funny feeling like you're being followed", (Object)"You feel something weird sneaking into your backpack", (Object)"You have a funny feeling like you would have been followed");
    private static final File CUSTOM_SOUNDS_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "custom-drop-sounds");
    private static final File HIGHLIGHTED_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "highlighted_sound.wav");
    private static final File BEGINNER_CLUE_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "beginner_clue_sound.wav");
    private static final File EASY_CLUE_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "easy_clue_sound.wav");
    private static final File MEDIUM_CLUE_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "medium_clue_sound.wav");
    private static final File HARD_CLUE_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "hard_clue_sound.wav");
    private static final File ELITE_CLUE_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "elite_clue_sound.wav");
    private static final File MASTER_CLUE_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "master_clue_sound.wav");
    private static final File LOW_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "low_sound.wav");
    private static final File MEDIUM_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "medium_sound.wav");
    private static final File PET_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "pet_sound.wav");
    private static final File HIGH_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "high_sound.wav");
    private static final File HIGHEST_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "highest_sound.wav");
    private static final File LOWEST_SOUND_FILE = new File(CUSTOM_SOUNDS_DIR, "lowest_sound.wav");
    private static final File[] SOUND_FILES = new File[]{HIGHLIGHTED_SOUND_FILE, BEGINNER_CLUE_SOUND_FILE, EASY_CLUE_SOUND_FILE, MEDIUM_CLUE_SOUND_FILE, HARD_CLUE_SOUND_FILE, ELITE_CLUE_SOUND_FILE, MASTER_CLUE_SOUND_FILE, LOW_SOUND_FILE, MEDIUM_SOUND_FILE, LOWEST_SOUND_FILE, HIGH_SOUND_FILE, HIGHEST_SOUND_FILE, PET_SOUND_FILE};
    private List<String> highlightedItemsList = new CopyOnWriteArrayList<String>();
    private Clip clip = null;

    @Provides
    CustomDropSoundsConfig provideConfig(ConfigManager configManager) {
        return (CustomDropSoundsConfig)configManager.getConfig(CustomDropSoundsConfig.class);
    }

    protected void startUp() {
        this.initSoundFiles();
        this.updateHighlightedItemsList();
    }

    protected void shutDown() {
        this.clip.close();
        this.clip = null;
        this.highlightedItemsList = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("grounditems") && configChanged.getKey().equals("highlightedItems")) {
            this.updateHighlightedItemsList();
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        int id = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        String name = itemComposition.getName().toLowerCase();
        if (this.config.highlightSound() && this.highlightedItemsList.contains(name)) {
            this.playSound(HIGHLIGHTED_SOUND_FILE);
            return;
        }
        int quantity = item.getQuantity();
        int gePrice = this.itemManager.getItemPrice(id) * quantity;
        int haPrice = itemComposition.getHaPrice() * quantity;
        int value = this.getValueByMode(gePrice, haPrice);
        if (this.config.beginnerClueSound() && name.contains("clue scroll (beginner)")) {
            this.playSound(BEGINNER_CLUE_SOUND_FILE);
        }
        if (this.config.easyClueSound() && name.contains("clue scroll (easy)")) {
            this.playSound(EASY_CLUE_SOUND_FILE);
        }
        if (this.config.mediumClueSound() && name.contains("clue scroll (medium)")) {
            this.playSound(MEDIUM_CLUE_SOUND_FILE);
        }
        if (this.config.hardClueSound() && name.contains("clue scroll (hard)")) {
            this.playSound(HARD_CLUE_SOUND_FILE);
        }
        if (this.config.eliteClueSound() && name.contains("clue scroll (elite)")) {
            this.playSound(ELITE_CLUE_SOUND_FILE);
        }
        if (this.config.masterClueSound() && name.contains("clue scroll (master)")) {
            this.playSound(MASTER_CLUE_SOUND_FILE);
        }
        if (this.config.lowestValueSound() && value >= this.config.lowestStart() && value < this.config.lowestEnd()) {
            this.playSound(LOWEST_SOUND_FILE);
        }
        if (this.config.lowValueSound() && value >= this.config.lowStart() && value < this.config.lowEnd()) {
            this.playSound(LOW_SOUND_FILE);
        }
        if (this.config.mediumValueSound() && value >= this.config.mediumStart() && value < this.config.mediumEnd()) {
            this.playSound(MEDIUM_SOUND_FILE);
        }
        if (this.config.highValueSound() && value >= this.config.highStart() && value < this.config.highEnd()) {
            this.playSound(HIGH_SOUND_FILE);
        }
        if (this.config.highestValueSound() && value >= this.config.highestStart() && value < this.config.highestEnd()) {
            this.playSound(HIGHEST_SOUND_FILE);
        }
    }

    private void playSound(File f) {
        try {
            AudioInputStream is = AudioSystem.getAudioInputStream(f);
            AudioFormat format = is.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(is);
            this.setVolume(this.config.masterVolume());
            this.clip.start();
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.warn("Sound file error", (Throwable)e);
        }
    }

    private void setVolume(int volume) {
        float vol = (float)volume / 100.0f;
        FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        gainControl.setValue(20.0f * (float)Math.log10(vol *= (float)this.config.masterVolume() / 100.0f));
    }

    private void initSoundFiles() {
        if (!CUSTOM_SOUNDS_DIR.exists()) {
            CUSTOM_SOUNDS_DIR.mkdirs();
        }
        for (File f : SOUND_FILES) {
            try {
                int bytesRead;
                if (f.exists()) continue;
                InputStream stream = CustomDropSoundsPlugin.class.getClassLoader().getResourceAsStream(f.getName());
                FileOutputStream out = new FileOutputStream(f);
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
                ((OutputStream)out).close();
                stream.close();
            }
            catch (Exception e) {
                log.debug(e + ": " + f);
            }
        }
    }

    private int getValueByMode(int gePrice, int haPrice) {
        switch (this.groundItemsConfig.valueCalculationMode()) {
            case GE: {
                return gePrice;
            }
            case HA: {
                return haPrice;
            }
        }
        return Math.max(gePrice, haPrice);
    }

    private void updateHighlightedItemsList() {
        if (!this.groundItemsConfig.getHighlightItems().isEmpty()) {
            this.highlightedItemsList = Text.fromCSV((String)this.groundItemsConfig.getHighlightItems().toLowerCase());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.TRADE && event.getType() != ChatMessageType.FRIENDSCHATNOTIFICATION) {
            return;
        }
        String chatMessage = event.getMessage();
        if (this.config.petSound()) {
            if (PET_MESSAGES.stream().anyMatch(chatMessage::contains)) {
                this.playSound(PET_SOUND_FILE);
            }
        }
    }
}

