/*
 * Decompiled with CFR 0.152.
 */
package com.github.i.platz;

import com.github.i.platz.PlatzConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="platz")
public class PlatzPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PlatzPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    PlatzConfig config;
    private static final int MY_TRADE_VALUE_WIDGET_ID = 21954584;
    private static final int OTHER_TRADE_VALUE_WIDGET_ID = 21954587;
    private static String[] suffix = new String[]{"", "K", "M", "B", "T"};
    private static final int MAX_SHORT_LENGTH = 10;

    protected void startUp() {
    }

    protected void shutDown() {
    }

    @Provides
    PlatzConfig provideConfig(ConfigManager configManager) {
        return (PlatzConfig)configManager.getConfig(PlatzConfig.class);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        int widgetIdToUpdate;
        int inventoryId = event.getContainerId();
        if (inventoryId == InventoryID.TRADEOTHER.getId()) {
            widgetIdToUpdate = 21954587;
        } else if (inventoryId == InventoryID.TRADE.getId()) {
            widgetIdToUpdate = 21954584;
        } else {
            return;
        }
        long total = 0L;
        for (Item item : this.client.getItemContainer(inventoryId).getItems()) {
            total += (long)this.itemManager.getItemPrice(item.getId()) * (long)item.getQuantity();
        }
        this.setTradeValueText(widgetIdToUpdate, total);
    }

    private void setTradeValueText(int widgetId, long value) {
        String formattedNumber = this.config.abbreviate() && value > this.config.largeNumberCutoff() ? PlatzPlugin.abbreviateBigNumber(value) : String.format("%,d", value);
        String msg = String.format("%s offer:<br>(Value: <col=ffffff>%s</col> coins)", widgetId == 21954584 ? "Your" : "Their", formattedNumber);
        this.client.getWidget(widgetId).setText(msg);
    }

    @VisibleForTesting
    public static String abbreviateBigNumber(long number) {
        Object r = new DecimalFormat("##0E0").format(number);
        r = ((String)r).replaceAll("E[0-9]", suffix[Character.getNumericValue(((String)r).charAt(((String)r).length() - 1)) / 3]);
        while (((String)r).length() > 10 || ((String)r).matches("[0-9]+\\.[a-z]")) {
            r = ((String)r).substring(0, ((String)r).length() - 2) + ((String)r).substring(((String)r).length() - 1);
        }
        return r;
    }
}

