/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup.views;

import com.lootlookup.LootLookupConfig;
import com.lootlookup.osrswiki.WikiItem;
import com.lootlookup.osrswiki.WikiScraper;
import com.lootlookup.utils.Util;
import com.lootlookup.views.PriceType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.IconTextField;

public class WikiItemPanel
extends JPanel {
    private LootLookupConfig config;
    private WikiItem item;
    private String imageUrl;
    private String itemName;
    private JButton percentBtn;
    private final Color bgColor = ColorScheme.DARKER_GRAY_COLOR;
    private final Color hoverColor = this.bgColor.brighter();
    private final JLabel rarityLabel = new JLabel();
    private final JLabel priceLabel = new JLabel();
    private final JLabel quantityLabel = new JLabel();
    private final JPanel imageContainer = new JPanel(new BorderLayout());
    private final JPanel leftSidePanel = new JPanel(new GridLayout(2, 1));
    private static int maxNameLength = 22;
    private static int labelsMaxLength = 25;

    public WikiItemPanel(final WikiItem item, LootLookupConfig config, boolean showSeparator, JButton percentButton) {
        this.item = item;
        this.config = config;
        this.imageUrl = item.getImageUrl();
        this.itemName = item.getName();
        this.percentBtn = percentButton;
        if (this.itemName.length() > maxNameLength) {
            this.itemName = this.itemName.replaceAll("\\(.*\\)", "").trim();
            if (this.itemName.length() > maxNameLength) {
                this.itemName = this.itemName.substring(0, maxNameLength) + "\u2026";
            }
        }
        percentButton.addItemListener(evt -> this.setRarityLabelText());
        this.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.setLayout(new BorderLayout());
        this.setBackground(this.bgColor);
        JPanel container = new JPanel(new BorderLayout());
        final JPanel paddingContainer = new JPanel(new BorderLayout());
        int padding = 2;
        paddingContainer.setBorder(new EmptyBorder(padding, padding, padding, padding));
        if (showSeparator) {
            container.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR));
        }
        paddingContainer.setBackground(this.bgColor);
        JPanel leftPanel = this.buildLeftPanel();
        final JPanel rightPanel = this.buildRightPanel();
        rightPanel.setBackground(this.bgColor);
        paddingContainer.add((Component)leftPanel, "West");
        paddingContainer.add((Component)rightPanel, "East");
        container.add(paddingContainer);
        this.rarityLabel.setFont(FontManager.getRunescapeSmallFont());
        this.rarityLabel.setForeground(config.commonColor());
        if (item.getRarity() > 0.0) {
            if (item.getRarity() <= 0.01) {
                this.rarityLabel.setForeground(config.rareColor());
            }
            if (item.getRarity() <= 0.001) {
                this.rarityLabel.setForeground(config.superRareColor());
            }
        }
        this.priceLabel.setFont(FontManager.getRunescapeSmallFont());
        this.priceLabel.setForeground(config.priceColor());
        if (!config.disableItemsLinks()) {
            Util.showHandCursorOnHover(container);
            container.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String wikiUrl = WikiScraper.getWikiUrl(item.getName());
                    try {
                        Desktop.getDesktop().browse(new URL(wikiUrl).toURI());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    WikiItemPanel.this.setBackground(WikiItemPanel.this.hoverColor);
                    paddingContainer.setBackground(WikiItemPanel.this.hoverColor);
                    WikiItemPanel.this.leftSidePanel.setBackground(WikiItemPanel.this.hoverColor);
                    rightPanel.setBackground(WikiItemPanel.this.hoverColor);
                    WikiItemPanel.this.imageContainer.setBackground(WikiItemPanel.this.hoverColor);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    WikiItemPanel.this.setBackground(WikiItemPanel.this.bgColor);
                    paddingContainer.setBackground(WikiItemPanel.this.bgColor);
                    WikiItemPanel.this.leftSidePanel.setBackground(WikiItemPanel.this.bgColor);
                    rightPanel.setBackground(WikiItemPanel.this.bgColor);
                    WikiItemPanel.this.imageContainer.setBackground(WikiItemPanel.this.bgColor);
                }
            });
        }
        if (this.itemName.endsWith("\u2026")) {
            container.setToolTipText(item.getName());
        }
        this.add(container);
    }

    private void downloadImage(JLabel imageLabel) {
        try {
            Util.downloadImage(this.imageUrl, image -> {
                BufferedImage img = this.item.getQuantityStr().endsWith(" (noted)") ? Util.getNotedImg(image) : image;
                imageLabel.setIcon(new ImageIcon(img));
                this.imageContainer.setBorder(new EmptyBorder(0, 5, 0, Math.max(30 - image.getWidth(), 5)));
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel buildImagePanel() {
        this.imageContainer.setSize(30, this.imageContainer.getHeight());
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(new ImageIcon(IconTextField.class.getResource(IconTextField.Icon.LOADING_DARKER.getFile())));
        new Thread(() -> this.downloadImage(imageLabel)).start();
        imageLabel.setSize(35, imageLabel.getWidth());
        this.imageContainer.add((Component)imageLabel, "West");
        this.imageContainer.setSize(30, this.imageContainer.getHeight());
        this.imageContainer.setBackground(this.bgColor);
        return this.imageContainer;
    }

    private JPanel buildLeftPanel() {
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 0));
        JPanel itemImage = this.buildImagePanel();
        this.leftSidePanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.leftSidePanel.setBackground(this.bgColor);
        JLabel itemNameLabel = new JLabel(this.itemName);
        itemNameLabel.setBorder(new EmptyBorder(0, 0, 3, 0));
        itemNameLabel.setFont(FontManager.getRunescapeBoldFont());
        itemNameLabel.setHorizontalAlignment(2);
        itemNameLabel.setVerticalAlignment(0);
        this.rarityLabel.setHorizontalAlignment(2);
        this.rarityLabel.setVerticalAlignment(0);
        this.setRarityLabelText();
        this.leftSidePanel.add(itemNameLabel);
        this.leftSidePanel.add(this.rarityLabel);
        container.add(itemImage);
        container.add(this.leftSidePanel);
        return container;
    }

    private JPanel buildRightPanel() {
        JPanel rightSidePanel = new JPanel(new GridLayout(2, 1));
        this.setQuantityLabelText();
        this.quantityLabel.setFont(FontManager.getRunescapeSmallFont());
        this.quantityLabel.setBorder(new EmptyBorder(0, 0, 3, 2));
        this.quantityLabel.setHorizontalAlignment(4);
        this.quantityLabel.setVerticalAlignment(0);
        this.setPriceLabelText();
        this.priceLabel.setVerticalAlignment(0);
        this.priceLabel.setHorizontalAlignment(4);
        rightSidePanel.add(this.quantityLabel);
        rightSidePanel.add(this.priceLabel);
        return rightSidePanel;
    }

    void setQuantityLabelText() {
        if (this.config != null && !this.config.showQuantity()) {
            this.quantityLabel.setText("");
        } else {
            this.quantityLabel.setText((this.itemName + this.item.getQuantityLabelText()).length() > labelsMaxLength ? this.item.getQuantityLabelTextShort() : this.item.getQuantityLabelText());
        }
    }

    void setRarityLabelText() {
        this.rarityLabel.setText(this.item.getRarityLabelText(this.percentBtn.isSelected()));
        if (this.config != null && !this.config.showRarity()) {
            this.rarityLabel.setText("");
        } else if (this.item.getRarity() < 0.0) {
            this.rarityLabel.setText(this.item.getRarityStr());
        }
    }

    void setPriceLabelText() {
        this.priceLabel.setText("");
        if (this.config != null && this.config.showPrice()) {
            String priceText = this.config.priceType() == PriceType.HA ? this.item.getAlchemyPriceLabelText() : this.item.getExchangePriceLabelText();
            String priceTextShort = this.config.priceType() == PriceType.HA ? this.item.getAlchemyPriceLabelTextShort() : this.item.getExchangePriceLabelTextShort();
            int price = this.config.priceType() == PriceType.HA ? this.item.getAlchemyPrice() : this.item.getExchangePrice();
            this.priceLabel.setText((this.itemName + priceText).length() > labelsMaxLength && price >= 1000 ? priceTextShort : priceText);
        }
    }
}

