/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup.views;

import com.lootlookup.LootLookupConfig;
import com.lootlookup.osrswiki.DropTableSection;
import com.lootlookup.osrswiki.WikiItem;
import com.lootlookup.utils.Util;
import com.lootlookup.views.TableBox;
import com.lootlookup.views.ViewOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.SwingUtil;

public class TableResultsPanel
extends JPanel {
    private LootLookupConfig config;
    private DropTableSection[] dropTableSections;
    private ViewOption viewOption;
    private JButton collapseBtn;
    private JButton percentButton;
    private final List<TableBox> boxes = new ArrayList<TableBox>();
    private int selectedTabIndex;
    private final JPanel dropTableContent = new JPanel();
    private final int maxHeaderLength = 31;

    public TableResultsPanel(LootLookupConfig config, DropTableSection[] dropTableSections, ViewOption viewOption, JButton collapseButton, JButton percentButton, int selectedTabIndex) {
        this.config = config;
        this.dropTableSections = dropTableSections;
        this.viewOption = viewOption;
        this.collapseBtn = collapseButton;
        this.percentButton = percentButton;
        this.selectedTabIndex = selectedTabIndex;
        this.setLayout(new BoxLayout(this, 1));
        this.dropTableContent.setLayout(new BoxLayout(this.dropTableContent, 1));
        JScrollPane scrollPane = new JScrollPane(this);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        if (dropTableSections.length > 1) {
            MaterialTabGroup tabGroup = new MaterialTabGroup();
            tabGroup.setLayout((LayoutManager)new GridLayout(1, dropTableSections.length, 7, 7));
            for (int i = 0; i < dropTableSections.length; ++i) {
                MaterialTab tab = new MaterialTab(String.valueOf(i + 1), tabGroup, null);
                this.buildMaterialTab(tab, i);
                if (i == selectedTabIndex) {
                    tab.select();
                }
                tabGroup.addTab(tab);
            }
            this.add((Component)tabGroup);
        }
        this.buildDropTableContent();
        this.add(this.dropTableContent);
    }

    void buildMaterialTab(MaterialTab tab, int index) {
        if (index < this.dropTableSections.length) {
            tab.setToolTipText(this.dropTableSections[index].getHeader());
            tab.setOnSelectEvent(() -> {
                this.selectedTabIndex = index;
                SwingUtilities.invokeLater(() -> {
                    this.remove(this.dropTableContent);
                    SwingUtil.fastRemoveAll((Container)this.dropTableContent);
                    this.buildDropTableContent();
                    this.add(this.dropTableContent);
                });
                return true;
            });
            tab.setOpaque(true);
            tab.setVerticalAlignment(0);
            tab.setHorizontalAlignment(0);
            tab.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            tab.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    MaterialTab tab = (MaterialTab)e.getSource();
                    tab.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    MaterialTab tab = (MaterialTab)e.getSource();
                    tab.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                }
            });
            Util.showHandCursorOnHover((Component)tab);
        }
    }

    void buildDropTableContent() {
        Map<Object, Object> dropTables;
        DropTableSection selectedSection = this.selectedTabIndex < this.dropTableSections.length ? this.dropTableSections[this.selectedTabIndex] : null;
        Map<Object, Object> map = dropTables = selectedSection != null ? selectedSection.getTable() : Collections.emptyMap();
        if (this.dropTableSections.length > 1) {
            this.dropTableContent.add(Box.createRigidArea(new Dimension(0, 5)));
            JPanel labelContainer = new JPanel(new BorderLayout());
            Object dropsHeaderText = selectedSection.getHeader();
            if (((String)dropsHeaderText).length() > 31) {
                dropsHeaderText = ((String)dropsHeaderText).substring(0, 31) + "\u2026";
            }
            JLabel sectionHeaderLabel = new JLabel((String)dropsHeaderText);
            sectionHeaderLabel.setFont(FontManager.getRunescapeBoldFont());
            sectionHeaderLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            if (((String)dropsHeaderText).endsWith("\u2026")) {
                sectionHeaderLabel.setToolTipText(selectedSection.getHeader());
            }
            labelContainer.add((Component)sectionHeaderLabel, "West");
            this.dropTableContent.add(labelContainer);
            this.dropTableContent.add(Box.createRigidArea(new Dimension(0, 5)));
            JPanel separator = new JPanel();
            separator.setPreferredSize(new Dimension(0, 6));
            separator.setBorder(new MatteBorder(1, 0, 0, 0, ColorScheme.DARKER_GRAY_COLOR));
            this.dropTableContent.add(separator);
        }
        for (Map.Entry<Object, Object> entry : dropTables.entrySet()) {
            String tableHeader = (String)entry.getKey();
            TableBox tableBox = new TableBox(this.config, (WikiItem[])entry.getValue(), this.viewOption, tableHeader, this.percentButton);
            this.boxes.add(tableBox);
            this.dropTableContent.add(tableBox);
            this.dropTableContent.add(Box.createRigidArea(new Dimension(0, 5)));
        }
    }

    void toggleCollapse() {
        for (TableBox box : this.boxes) {
            if (!this.collapseBtn.isSelected()) {
                box.expand();
                continue;
            }
            if (box.isCollapsed()) continue;
            box.collapse();
        }
    }

    String getSelectedHeader() {
        DropTableSection selectedSection;
        DropTableSection dropTableSection = selectedSection = this.selectedTabIndex < this.dropTableSections.length ? this.dropTableSections[this.selectedTabIndex] : null;
        if (selectedSection != null) {
            return selectedSection.getHeader();
        }
        return null;
    }

    int getSelectedIndex() {
        return this.selectedTabIndex;
    }

    void resetSelectedIndex() {
        this.selectedTabIndex = 0;
    }

    void setSelectedIndex(int index) {
        this.selectedTabIndex = index;
    }
}

