/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup.views;

import com.lootlookup.LootLookupConfig;
import com.lootlookup.osrswiki.WikiItem;
import com.lootlookup.utils.Icons;
import com.lootlookup.utils.Util;
import com.lootlookup.views.GridPanel;
import com.lootlookup.views.ViewOption;
import com.lootlookup.views.WikiItemPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.SwingUtil;

public class TableBox
extends JPanel {
    private LootLookupConfig config;
    private WikiItem[] items;
    private ViewOption viewOption;
    private String fullHeaderStr;
    private String headerStr;
    private JButton percentBtn;
    private final JButton collapseBtn = new JButton();
    private final JPanel listViewContainer = new JPanel();
    private JPanel gridViewPanel = new JPanel();
    private final JPanel headerContainer = new JPanel();
    private final JPanel leftHeader = new JPanel();
    private final Color HEADER_BG_COLOR = ColorScheme.DARKER_GRAY_COLOR.darker();
    private final Color HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR.darker();
    private final List<WikiItemPanel> itemPanels = new ArrayList<WikiItemPanel>();
    private static int maxHeaderLength = 28;

    public TableBox(LootLookupConfig config, WikiItem[] items, ViewOption viewOption, String headerStr, JButton percentButton) {
        this.config = config;
        this.items = items;
        this.fullHeaderStr = headerStr;
        this.headerStr = headerStr;
        this.viewOption = viewOption;
        this.percentBtn = percentButton;
        this.setLayout(new BoxLayout(this, 1));
        this.buildHeader();
        this.buildItemsContainer();
    }

    void buildHeader() {
        this.buildLeftHeader();
        this.buildHeaderContainer();
    }

    void buildLeftHeader() {
        if (this.headerStr.length() > maxHeaderLength) {
            this.headerStr = this.headerStr.substring(0, maxHeaderLength) + "\u2026";
        }
        JLabel headerLabel = new JLabel(this.headerStr);
        headerLabel.setFont(FontManager.getRunescapeBoldFont());
        headerLabel.setForeground(ColorScheme.BRAND_ORANGE);
        headerLabel.setHorizontalAlignment(0);
        this.leftHeader.setLayout(new BoxLayout(this.leftHeader, 0));
        this.leftHeader.setBackground(this.HEADER_BG_COLOR);
        this.buildCollapseBtn();
        this.leftHeader.add(Box.createRigidArea(new Dimension(5, 0)));
        this.leftHeader.add(this.collapseBtn);
        this.leftHeader.add(Box.createRigidArea(new Dimension(10, 0)));
        this.leftHeader.add(headerLabel);
    }

    void buildCollapseBtn() {
        SwingUtil.removeButtonDecorations((AbstractButton)this.collapseBtn);
        this.collapseBtn.setIcon(Icons.EXPAND_ICON);
        this.collapseBtn.setSelectedIcon(Icons.COLLAPSE_ICON);
        SwingUtil.addModalTooltip((AbstractButton)this.collapseBtn, (String)"Expand Table", (String)"Collapse Table");
        this.collapseBtn.setBackground(this.HEADER_BG_COLOR);
        this.collapseBtn.setUI(new BasicButtonUI());
        this.collapseBtn.addActionListener(evt -> this.toggleCollapse());
        Util.showHandCursorOnHover(this.collapseBtn);
    }

    void buildHeaderContainer() {
        this.headerContainer.setLayout(new BorderLayout());
        this.headerContainer.setBackground(this.HEADER_BG_COLOR);
        this.headerContainer.setPreferredSize(new Dimension(0, 40));
        Util.showHandCursorOnHover(this.headerContainer);
        this.headerContainer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TableBox.this.toggleCollapse();
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TableBox.this.headerContainer.setBackground(TableBox.this.HOVER_COLOR);
                TableBox.this.leftHeader.setBackground(TableBox.this.HOVER_COLOR);
                TableBox.this.collapseBtn.setBackground(TableBox.this.HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TableBox.this.headerContainer.setBackground(TableBox.this.HEADER_BG_COLOR);
                TableBox.this.leftHeader.setBackground(TableBox.this.HEADER_BG_COLOR);
                TableBox.this.collapseBtn.setBackground(TableBox.this.HEADER_BG_COLOR);
            }
        });
        if (this.headerStr.endsWith("\u2026")) {
            this.headerContainer.setToolTipText(this.fullHeaderStr);
        }
        this.headerContainer.add((Component)this.leftHeader, "West");
        this.add(this.headerContainer);
    }

    void buildItemsContainer() {
        switch (this.viewOption) {
            case LIST: {
                int i = 0;
                for (WikiItem item : this.items) {
                    WikiItemPanel itemPanel = new WikiItemPanel(item, this.config, i > 0, this.percentBtn);
                    this.itemPanels.add(itemPanel);
                    this.listViewContainer.add(itemPanel);
                    ++i;
                }
                this.listViewContainer.setLayout(new BoxLayout(this.listViewContainer, 1));
                this.add(this.listViewContainer);
                break;
            }
            case GRID: {
                this.gridViewPanel = new GridPanel(this.items, this.config, this.percentBtn);
                this.add(this.gridViewPanel);
            }
        }
    }

    void collapse() {
        if (!this.isCollapsed()) {
            this.collapseBtn.setSelected(true);
            this.listViewContainer.setVisible(false);
            this.gridViewPanel.setVisible(false);
        }
    }

    void expand() {
        if (this.isCollapsed()) {
            this.collapseBtn.setSelected(false);
            this.listViewContainer.setVisible(true);
            this.gridViewPanel.setVisible(true);
        }
    }

    void toggleCollapse() {
        if (this.isCollapsed()) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    boolean isCollapsed() {
        return this.collapseBtn.isSelected();
    }
}

