/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup.views;

import com.lootlookup.LootLookupConfig;
import com.lootlookup.osrswiki.DropTableSection;
import com.lootlookup.osrswiki.WikiScraper;
import com.lootlookup.utils.Icons;
import com.lootlookup.utils.Util;
import com.lootlookup.views.TableResultsPanel;
import com.lootlookup.views.ViewOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.SwingUtil;

public class LootLookupPanel
extends PluginPanel {
    private LootLookupConfig config;
    private TableResultsPanel tablePanel;
    private DropTableSection[] dropTableSections;
    private ViewOption viewOption = ViewOption.LIST;
    private IconTextField monsterSearchField = new IconTextField();
    private final JPanel mainPanel = new JPanel();
    private final JPanel actionsContainer = new JPanel();
    private final JPanel actionsLeft = new JPanel();
    private final JButton collapseBtn = new JButton();
    private final JPanel actionsRight = new JPanel();
    private final JButton percentBtn = new JButton();
    JRadioButton listBtn = new JRadioButton();
    JRadioButton gridBtn = new JRadioButton();
    JToggleButton externalLinkBtn = new JToggleButton();
    private final JPanel externalLinkBtnContainer = new JPanel();
    private final JPanel listBtnContainer = new JPanel();
    private final JPanel gridBtnContainer = new JPanel();
    ButtonGroup viewOptionGroup = new ButtonGroup();
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private int targetCombatLevel = 0;
    private int targetMonsterId = -1;

    public LootLookupPanel(LootLookupConfig config) {
        this.config = config;
        if (config != null) {
            this.viewOption = config.viewOption();
        }
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.buildSearchField();
        this.actionsContainer.setLayout(new BorderLayout());
        this.actionsContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.actionsContainer.setPreferredSize(new Dimension(0, 29));
        this.actionsLeft.setLayout(new BoxLayout(this.actionsLeft, 0));
        this.actionsLeft.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.actionsRight.setLayout(new BoxLayout(this.actionsRight, 0));
        this.actionsRight.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.buildButton(this.collapseBtn, Icons.EXPAND_ICON, Icons.COLLAPSE_ICON, "Expand All", "Collapse All", evt -> {
            this.collapseBtn.setSelected(!this.collapseBtn.isSelected());
            this.tablePanel.toggleCollapse();
        });
        SwingUtil.removeButtonDecorations((AbstractButton)this.listBtn);
        this.listBtn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.listBtn.setIcon(Icons.LIST_ICON_FADED);
        this.listBtn.setRolloverIcon(Icons.LIST_ICON_HOVER);
        this.listBtn.setSelectedIcon(Icons.LIST_ICON);
        Util.showHandCursorOnHover(this.listBtn);
        this.listBtn.setToolTipText("List");
        this.listBtn.addActionListener(evt -> {
            this.viewOption = ViewOption.LIST;
            this.refreshMainPanel();
        });
        this.listBtn.setSelected(this.viewOption == ViewOption.LIST);
        this.listBtnContainer.setLayout(new BorderLayout());
        this.listBtnContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        SwingUtil.removeButtonDecorations((AbstractButton)this.gridBtn);
        this.gridBtn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.gridBtn.setIcon(Icons.GRID_ICON_FADED);
        this.gridBtn.setRolloverIcon(Icons.GRID_ICON_HOVER);
        this.gridBtn.setSelectedIcon(Icons.GRID_ICON);
        Util.showHandCursorOnHover(this.gridBtn);
        this.gridBtn.setToolTipText("Grid");
        this.gridBtn.addActionListener(evt -> {
            this.viewOption = ViewOption.GRID;
            this.refreshMainPanel();
        });
        this.gridBtn.setSelected(this.viewOption == ViewOption.GRID);
        this.gridBtnContainer.setLayout(new BorderLayout());
        this.gridBtnContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.viewOptionGroup.add(this.listBtn);
        this.viewOptionGroup.add(this.gridBtn);
        this.buildButton(this.percentBtn, Icons.PERCENT_ICON_FADED, Icons.PERCENT_ICON, "Toggle Rarity Percentage", "Toggle Rarity Percentage", evt -> this.percentBtn.setSelected(!this.percentBtn.isSelected()));
        SwingUtil.removeButtonDecorations((AbstractButton)this.externalLinkBtn);
        this.externalLinkBtn.setIcon(Icons.EXTERNAL_LINK_ICON);
        this.externalLinkBtn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.externalLinkBtn.setUI(new BasicButtonUI());
        this.externalLinkBtn.setRolloverIcon(Icons.EXTERNAL_LINK_ICON_HOVER);
        this.externalLinkBtn.setToolTipText("Wiki");
        Util.showHandCursorOnHover(this.externalLinkBtn);
        this.externalLinkBtn.addActionListener(evt -> {
            String wikiUrl = WikiScraper.getWikiUrlForDrops(this.monsterSearchField.getText(), this.tablePanel.getSelectedHeader(), this.targetMonsterId);
            try {
                Desktop.getDesktop().browse(new URL(wikiUrl).toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.externalLinkBtnContainer.setLayout(new BorderLayout());
        this.errorPanel.setContent("Loot Lookup", "Enter a monster name or select the in-game option.");
        this.add((Component)this.monsterSearchField);
        this.add(this.mainPanel);
        this.add((Component)this.errorPanel);
    }

    void rebuildMainPanel() {
        this.remove((Component)this.errorPanel);
        SwingUtil.fastRemoveAll((Container)this.mainPanel);
        int defaultSelectedIndex = this.getSelectedIndexForCombatLevel(this.targetCombatLevel);
        this.tablePanel = new TableResultsPanel(this.config, this.dropTableSections, this.viewOption, this.collapseBtn, this.percentBtn, this.tablePanel != null ? this.tablePanel.getSelectedIndex() : defaultSelectedIndex);
        this.actionsLeft.add(Box.createRigidArea(new Dimension(5, 0)));
        this.actionsLeft.add(this.collapseBtn);
        this.listBtnContainer.add((Component)this.listBtn, "Center");
        this.actionsRight.add(this.listBtnContainer);
        this.gridBtnContainer.add((Component)this.gridBtn, "Center");
        this.actionsRight.add(this.gridBtnContainer);
        if (this.config != null & this.config.showRarity()) {
            this.actionsRight.add(this.percentBtn);
        }
        this.actionsRight.add(Box.createRigidArea(new Dimension(5, 0)));
        this.externalLinkBtnContainer.add((Component)this.externalLinkBtn, "Center");
        this.actionsRight.add(this.externalLinkBtnContainer);
        this.actionsContainer.add((Component)this.actionsLeft, "West");
        this.actionsContainer.add((Component)this.actionsRight, "East");
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.mainPanel.add(this.actionsContainer);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.mainPanel.add(this.tablePanel);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    void resetMainPanel() {
        SwingUtil.fastRemoveAll((Container)this.mainPanel);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
        this.add((Component)this.errorPanel);
    }

    void buildSearchField() {
        this.monsterSearchField.setIcon(IconTextField.Icon.SEARCH);
        this.monsterSearchField.setPreferredSize(new Dimension(205, 30));
        this.monsterSearchField.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.monsterSearchField.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.monsterSearchField.setMinimumSize(new Dimension(0, 30));
        this.monsterSearchField.addActionListener(evt -> this.searchForMonsterName(this.monsterSearchField.getText(), 0, -1));
        this.monsterSearchField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LootLookupPanel.this.searchForMonsterName(LootLookupPanel.this.monsterSearchField.getText(), 0, -1);
            }
        });
        this.monsterSearchField.addClearListener(() -> this.reset());
    }

    void buildButton(JButton btn, ImageIcon icon, ImageIcon selectedIcon, String on, String off, ActionListener listener) {
        SwingUtil.removeButtonDecorations((AbstractButton)btn);
        btn.setIcon(icon);
        btn.setSelectedIcon(selectedIcon);
        btn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        btn.setUI(new BasicButtonUI());
        SwingUtil.addModalTooltip((AbstractButton)btn, (String)on, (String)off);
        Util.showHandCursorOnHover(btn);
        btn.addActionListener(listener);
    }

    int getSelectedIndexForCombatLevel(int combatLevel) {
        if (combatLevel > 0) {
            for (int i = 0; i < this.dropTableSections.length; ++i) {
                DropTableSection section = this.dropTableSections[i];
                String headerTextLower = section.getHeader().toLowerCase();
                if (headerTextLower.contains(String.valueOf(combatLevel))) {
                    return i;
                }
                try {
                    String[] headerTextTokens;
                    for (String token : headerTextTokens = headerTextLower.split("\\s+")) {
                        String[] rangeTokens;
                        if (!token.contains("\u2013") || (rangeTokens = token.split("\u2013")).length <= 1 || !rangeTokens[0].matches("\\d+") || !rangeTokens[1].matches("\\d+")) continue;
                        int rangeLow = Integer.parseInt(rangeTokens[0]);
                        int rangeHigh = Integer.parseInt(rangeTokens[1]);
                        if (combatLevel < rangeLow || combatLevel > rangeHigh) continue;
                        return i;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    void searchForMonsterName(String monsterName, int combatLevel, int monsterId) {
        if (monsterName.isEmpty()) {
            return;
        }
        this.monsterSearchField.setEditable(false);
        this.monsterSearchField.setIcon(IconTextField.Icon.LOADING_DARKER);
        this.targetCombatLevel = combatLevel;
        this.targetMonsterId = monsterId;
        WikiScraper.getDropsByMonster(monsterName, monsterId).whenCompleteAsync((dropTableSections, ex) -> {
            this.dropTableSections = dropTableSections;
            if (this.tablePanel != null) {
                this.tablePanel.resetSelectedIndex();
                this.tablePanel.setSelectedIndex(this.getSelectedIndexForCombatLevel(combatLevel));
            }
            this.monsterSearchField.setIcon(((DropTableSection[])dropTableSections).length == 0 ? IconTextField.Icon.ERROR : IconTextField.Icon.SEARCH);
            this.monsterSearchField.setEditable(true);
            this.refreshMainPanel();
        });
    }

    void resetSearchField() {
        this.monsterSearchField.setIcon(IconTextField.Icon.SEARCH);
        this.monsterSearchField.setText("");
        this.monsterSearchField.setEditable(true);
    }

    public void reset() {
        SwingUtilities.invokeLater(() -> {
            this.resetSearchField();
            this.resetMainPanel();
        });
    }

    public void lookupMonsterDrops(String monsterName, int combatLevel, int monsterId) {
        this.targetCombatLevel = combatLevel;
        this.targetMonsterId = monsterId;
        SwingUtilities.invokeLater(() -> {
            this.monsterSearchField.setText(monsterName);
            this.searchForMonsterName(monsterName, combatLevel, monsterId);
        });
    }

    public void refreshMainPanel() {
        if (this.dropTableSections != null && this.dropTableSections.length > 0) {
            SwingUtilities.invokeLater(() -> this.rebuildMainPanel());
        }
    }
}

