/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup.views;

import com.lootlookup.LootLookupConfig;
import com.lootlookup.osrswiki.WikiItem;
import com.lootlookup.views.GridItem;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class GridPanel
extends JPanel {
    public GridPanel(WikiItem[] items, LootLookupConfig config, JButton percentButton) {
        int itemsPerRow = config.gridRowOption().getValue();
        int rowSize = (items.length % itemsPerRow == 0 ? 0 : 1) + items.length / itemsPerRow;
        this.setLayout(new GridLayout(rowSize, itemsPerRow, 0, 0));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        for (int i = 0; i < rowSize * itemsPerRow; ++i) {
            JPanel slotContainer = new JPanel();
            slotContainer.setLayout(new BoxLayout(slotContainer, 0));
            if (i < items.length) {
                slotContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                slotContainer.add(new GridItem(items[i], config, percentButton));
                slotContainer.add(Box.createRigidArea(new Dimension(1, 0)));
                slotContainer.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR, 1));
            }
            this.add(slotContainer);
        }
    }
}

