/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup.views;

import com.lootlookup.LootLookupConfig;
import com.lootlookup.osrswiki.WikiItem;
import com.lootlookup.utils.Util;
import com.lootlookup.views.PriceType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.IconTextField;

public class GridItem
extends JPanel {
    private WikiItem item;
    private LootLookupConfig config;
    private JButton percentBtn;
    private String rarityColorStr;
    private String priceColorStr;
    private final JPanel container = new JPanel();
    private final JLabel imageLabel = new JLabel();
    private final Color bgColor = ColorScheme.DARKER_GRAY_COLOR;
    private static int maxQuantityLength = 6;

    public GridItem(WikiItem item, LootLookupConfig config, JButton percentButton) {
        this.item = item;
        this.config = config;
        this.percentBtn = percentButton;
        this.priceColorStr = Util.colorToHex(config.priceColor());
        this.rarityColorStr = Util.colorToHex(config.commonColor());
        if (item.getRarity() > 0.0) {
            if (item.getRarity() <= 0.01) {
                this.rarityColorStr = Util.colorToHex(config.rareColor());
            }
            if (item.getRarity() <= 0.001) {
                this.rarityColorStr = Util.colorToHex(config.superRareColor());
            }
        }
        this.imageLabel.setIcon(new ImageIcon(IconTextField.class.getResource(IconTextField.Icon.LOADING_DARKER.getFile())));
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setHorizontalAlignment(0);
        this.container.setBackground(this.bgColor);
        this.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.setLayout(new BorderLayout());
        new Thread(() -> Util.downloadImage(item.getImageUrl(), image -> {
            BufferedImage img = item.getQuantityStr().endsWith(" (noted)") ? Util.getNotedImg(image) : image;
            this.imageLabel.setIcon(new ImageIcon(img));
        })).start();
        JPanel bottomText = new JPanel();
        bottomText.setBackground(new Color(0, 0, 0, 0));
        bottomText.setLayout(new BorderLayout());
        String quantityLabelTextShort = item.getQuantityLabelTextShort();
        JLabel quantityLabel = new JLabel(quantityLabelTextShort.length() > maxQuantityLength ? item.getQuantityValueText() : quantityLabelTextShort);
        quantityLabel.setBackground(this.bgColor);
        quantityLabel.setFont(FontManager.getRunescapeSmallFont());
        this.setBackground(this.bgColor);
        this.setTooltipText();
        percentButton.addItemListener(evt -> this.setTooltipText());
        this.container.add(this.imageLabel);
        this.add((Component)this.container, "Center");
        if (config.showQuantity()) {
            bottomText.add((Component)quantityLabel, "East");
        }
        this.add((Component)bottomText, "South");
    }

    void setTooltipText() {
        String priceText = this.config.priceType() == PriceType.HA ? this.item.getAlchemyPriceLabelText() : this.item.getExchangePriceLabelText();
        this.setToolTipText("<html>" + this.item.getName() + (String)(this.config.showQuantity() ? "<br>" + this.item.getQuantityLabelText() : "") + (String)(this.config.showRarity() ? "<br><font color=\"" + this.rarityColorStr + "\">" + (this.item.getRarity() < 0.0 ? this.item.getRarityStr() : this.item.getRarityLabelText(this.percentBtn.isSelected())) + "</font>" : "") + (String)(this.config.showPrice() ? "<br><font color=\"" + this.priceColorStr + "\">" + priceText + "</font>" : "") + "</html>");
    }
}

