/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup.osrswiki;

import com.lootlookup.utils.Util;
import java.text.NumberFormat;

public class WikiItem {
    private String imageUrl;
    private String name;
    private int quantity;
    private String quantityStr;
    private String rarityStr;
    private double rarity;
    private int exchangePrice;
    private int alchemyPrice;
    NumberFormat nf = NumberFormat.getNumberInstance();

    public WikiItem(String imageUrl, String name, int quantity, String quantityStr, String rarityStr, double rarity, int exchangePrice, int alchemyPrice) {
        this.imageUrl = imageUrl;
        this.name = name;
        this.quantity = quantity;
        this.quantityStr = quantityStr;
        this.rarityStr = rarityStr;
        this.rarity = rarity;
        this.exchangePrice = exchangePrice;
        this.alchemyPrice = alchemyPrice;
    }

    public String getName() {
        return this.name;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public String getQuantityStr() {
        return this.quantityStr;
    }

    public double getRarity() {
        return this.rarity;
    }

    public String getRarityStr() {
        return this.rarityStr;
    }

    public int getExchangePrice() {
        return this.exchangePrice;
    }

    public int getAlchemyPrice() {
        return this.alchemyPrice;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getQuantityLabelText() {
        if (this.quantityStr.contains("-") || this.quantityStr.endsWith(" (noted)")) {
            return "x" + this.quantityStr;
        }
        return this.quantity > 0 ? "x" + this.nf.format(this.quantity) : this.quantityStr;
    }

    public String getQuantityLabelTextShort() {
        if (this.quantityStr.endsWith(" (noted)")) {
            return "x" + this.quantityStr.replaceAll("\\(.*\\)", "(n)").trim();
        }
        return this.getQuantityValueText();
    }

    public String getQuantityValueText() {
        return this.quantity > 0 ? "x" + Util.rsFormat(this.quantity) : "";
    }

    public String getRarityLabelText(boolean percentMode) {
        String rarityLabelStr;
        String string = rarityLabelStr = this.rarityStr.contains(";") || this.rarityStr.equals("Always") || this.rarityStr.contains(" \u00d7 ") ? this.rarityStr : Util.convertDecimalToFraction(this.rarity);
        if (percentMode) {
            rarityLabelStr = Util.toPercentage(this.rarity, this.rarity <= 1.0E-4 ? 3 : 2);
        }
        return rarityLabelStr;
    }

    public String getExchangePriceLabelText() {
        String priceLabelStr;
        String string = priceLabelStr = this.exchangePrice > 0 ? this.nf.format(this.exchangePrice) + "gp" : "Not sold";
        if (this.name.equals("Nothing")) {
            priceLabelStr = "";
        }
        return priceLabelStr;
    }

    public String getExchangePriceLabelTextShort() {
        String priceLabelStr;
        String string = priceLabelStr = this.exchangePrice > 0 ? Util.rsFormat(this.exchangePrice) : "";
        if (this.name.equals("Nothing")) {
            priceLabelStr = "";
        }
        return priceLabelStr;
    }

    public String getAlchemyPriceLabelText() {
        Object priceLabelStr = this.nf.format(this.alchemyPrice) + "gp";
        if (this.name.equals("Nothing") || this.alchemyPrice < 0) {
            priceLabelStr = "";
        }
        return priceLabelStr;
    }

    public String getAlchemyPriceLabelTextShort() {
        String priceLabelStr;
        String string = priceLabelStr = this.alchemyPrice > 0 ? this.nf.format(this.alchemyPrice) + "gp" : "";
        if (this.name.equals("Nothing") || this.alchemyPrice < 0) {
            priceLabelStr = "";
        }
        return priceLabelStr;
    }
}

