/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup;

import com.google.inject.Provides;
import com.lootlookup.LootLookupConfig;
import com.lootlookup.utils.Icons;
import com.lootlookup.views.LootLookupPanel;
import java.util.Arrays;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.MenuOpened;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;

@PluginDescriptor(name="Loot Lookup")
public class LootLookupPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private LootLookupConfig config;
    private LootLookupPanel panel;
    private NavigationButton navButton;

    protected void startUp() {
        this.panel = new LootLookupPanel(this.config);
        this.navButton = NavigationButton.builder().tooltip("Loot Lookup").icon(Icons.NAV_BUTTON).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("Loot-Lookup")) {
            switch (event.getKey()) {
                case "showRarity": 
                case "showQuantity": 
                case "showPrice": 
                case "priceType": 
                case "disableItemLinks": 
                case "commonColor": 
                case "rareColor": 
                case "superRareColor": 
                case "priceColor": 
                case "gridRowOption": {
                    if (this.panel == null) break;
                    this.panel.refreshMainPanel();
                }
            }
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        MenuEntry[] menuEntries = event.getMenuEntries();
        boolean isTargetAttackableNPC = false;
        String targetMonsterName = "";
        int combatLevel = 0;
        int monsterId = -1;
        for (MenuEntry menuEntry : menuEntries) {
            NPC target;
            MenuAction menuType = menuEntry.getType();
            if (menuType != MenuAction.EXAMINE_NPC && menuType != MenuAction.NPC_SECOND_OPTION && menuType != MenuAction.NPC_FIFTH_OPTION) continue;
            String optionText = menuEntry.getOption();
            int id = menuEntry.getIdentifier();
            if (id >= cachedNPCs.length || (target = cachedNPCs[id]) == null) continue;
            combatLevel = target.getCombatLevel();
            monsterId = target.getId();
            if (!optionText.equals("Attack") || combatLevel <= 0) continue;
            isTargetAttackableNPC = true;
            targetMonsterName = target.getName();
        }
        if (isTargetAttackableNPC && !this.config.disableMenuOption()) {
            MenuEntry entryToAppendOn = menuEntries[menuEntries.length - 1];
            int idx = Arrays.asList(menuEntries).indexOf(entryToAppendOn);
            String finalTargetMonsterName = targetMonsterName;
            int finalCombatLevel = combatLevel;
            int finalMonsterId = monsterId;
            this.client.createMenuEntry(idx - 1).setOption("Lookup Drops").setTarget(entryToAppendOn.getTarget()).setIdentifier(entryToAppendOn.getIdentifier()).setParam1(entryToAppendOn.getParam1()).setType(MenuAction.of((int)MenuAction.RUNELITE.getId())).onClick(evt -> {
                this.selectNavButton();
                this.panel.lookupMonsterDrops(finalTargetMonsterName, finalCombatLevel, finalMonsterId);
            });
        }
    }

    @Provides
    LootLookupConfig provideConfig(ConfigManager configManager) {
        return (LootLookupConfig)configManager.getConfig(LootLookupConfig.class);
    }

    public void selectNavButton() {
        SwingUtilities.invokeLater(() -> {
            if (!this.navButton.isSelected()) {
                this.navButton.getOnSelect().run();
            }
        });
    }
}

