/*
 * Decompiled with CFR 0.152.
 */
package com.lootlookup;

import com.lootlookup.utils.Constants;
import com.lootlookup.views.GridRowOption;
import com.lootlookup.views.PriceType;
import com.lootlookup.views.ViewOption;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;

@ConfigGroup(value="Loot-Lookup")
public interface LootLookupConfig
extends Config {
    @ConfigItem(position=0, keyName="defaultViewOption", name="Default view option", description="Select default view option")
    default public ViewOption viewOption() {
        return ViewOption.LIST;
    }

    @ConfigItem(position=1, keyName="showRarity", name="Rarity", description="Show/hide rarity for item")
    default public boolean showRarity() {
        return true;
    }

    @ConfigItem(position=2, keyName="showQuantity", name="Quantity", description="Show/hide quantity for item")
    default public boolean showQuantity() {
        return true;
    }

    @ConfigItem(position=3, keyName="showPrice", name="Show Price", description="Show/hide price for item")
    default public boolean showPrice() {
        return false;
    }

    @ConfigItem(position=4, keyName="priceType", name="Price Type", description="Select price type for item")
    default public PriceType priceType() {
        return PriceType.GE;
    }

    @ConfigItem(position=5, keyName="disableMenuOption", name="Disable Right Click Menu option", description="Disable the right click menu option for monsters")
    default public boolean disableMenuOption() {
        return false;
    }

    @ConfigItem(position=6, keyName="disableItemLinks", name="Disable Item links (List only)", description="Disable links to OSRS Wiki page for item")
    default public boolean disableItemsLinks() {
        return false;
    }

    @ConfigItem(position=7, keyName="gridRowOption", name="Items per row (Grid only)", description="Number of items displayed in a grid row")
    default public GridRowOption gridRowOption() {
        return GridRowOption.FOUR;
    }

    @ConfigItem(position=8, keyName="commonColor", name="Common Color", description="Color to highlight the rarity of items with a value greater than 1/100")
    default public Color commonColor() {
        return Constants.DEFAULT_COMMON_COLOR;
    }

    @ConfigItem(position=9, keyName="rareColor", name="Rare Color", description="Color to highlight the rarity of items with a value of 1/100 - 1/1000")
    default public Color rareColor() {
        return Constants.DEFAULT_RARE_COLOR;
    }

    @ConfigItem(position=10, keyName="superRareColor", name="Super Rare Color", description="Color to highlight the rarity of items with a value of 1/1000 or less")
    default public Color superRareColor() {
        return Constants.DEFAULT_SUPER_RARE_COLOR;
    }

    @ConfigItem(position=11, keyName="priceColor", name="Price Color", description="Color to highlight item prices")
    default public Color priceColor() {
        return Constants.DEFAULT_PRICE_COLOR;
    }
}

