/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.esspouch;

enum Pouch {
    SMALL(3),
    MEDIUM(6, 3),
    LARGE(9, 7),
    GIANT(12, 9),
    COLOSSAL(40, 35);

    private final int baseHoldAmount;
    private final int degradedBaseHoldAmount;
    private int holding;
    private boolean degraded;
    private boolean unknown = true;

    private Pouch(int holdAmount) {
        this(holdAmount, -1);
    }

    private Pouch(int holdAmount, int degradedHoldAmount) {
        this.baseHoldAmount = holdAmount;
        this.degradedBaseHoldAmount = degradedHoldAmount;
    }

    int getHoldAmount() {
        return this.degraded ? this.degradedBaseHoldAmount : this.baseHoldAmount;
    }

    int getRemaining() {
        int holdAmount = this.degraded ? this.degradedBaseHoldAmount : this.baseHoldAmount;
        return holdAmount - this.holding;
    }

    void addHolding(int delta) {
        int holdAmount;
        this.holding += delta;
        int n = holdAmount = this.degraded ? this.degradedBaseHoldAmount : this.baseHoldAmount;
        if (this.holding < 0) {
            this.holding = 0;
        }
        if (this.holding > holdAmount) {
            this.holding = holdAmount;
        }
    }

    void degrade(boolean state) {
        if (state != this.degraded) {
            this.degraded = state;
            int holdAmount = this.degraded ? this.degradedBaseHoldAmount : this.baseHoldAmount;
            this.holding = Math.min(this.holding, holdAmount);
        }
    }

    static Pouch forItem(int itemId) {
        switch (itemId) {
            case 5509: {
                return SMALL;
            }
            case 5510: 
            case 5511: {
                return MEDIUM;
            }
            case 5512: 
            case 5513: {
                return LARGE;
            }
            case 5514: 
            case 5515: {
                return GIANT;
            }
            case 26784: 
            case 26786: 
            case 26906: {
                return COLOSSAL;
            }
        }
        return null;
    }

    int getHolding() {
        return this.holding;
    }

    void setHolding(int holding) {
        this.holding = holding;
    }

    boolean isDegraded() {
        return this.degraded;
    }

    boolean isUnknown() {
        return this.unknown;
    }

    void setUnknown(boolean unknown) {
        this.unknown = unknown;
    }
}

