/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.esspouch;

import com.google.common.collect.ImmutableMap;
import info.sigterm.plugins.esspouch.ClickOperation;
import info.sigterm.plugins.esspouch.EssencePouchOverlay;
import info.sigterm.plugins.esspouch.Pouch;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Essence Pouch", description="Shows how many essence are in an essence pouch", tags={"ess", "runecraft"})
public class EssPouchPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EssPouchPlugin.class);
    private static final int INVENTORY_SIZE = 28;
    private static final int GOTR_WIDGET_ID = 48889876;
    private static final String POUCH_ADD_FULL_MESSAGE = "You cannot add any more essence to the pouch.";
    private static final Pattern POUCH_CHECK_MESSAGE = Pattern.compile("^There (?:is|are) ([a-z-]+)(?: pure| daeyalt| guardian)? essences? in this pouch\\.$");
    private static final ImmutableMap<String, Integer> TEXT_TO_NUMBER = ImmutableMap.builder().put((Object)"no", (Object)0).put((Object)"one", (Object)1).put((Object)"two", (Object)2).put((Object)"three", (Object)3).put((Object)"four", (Object)4).put((Object)"five", (Object)5).put((Object)"six", (Object)6).put((Object)"seven", (Object)7).put((Object)"eight", (Object)8).put((Object)"nine", (Object)9).put((Object)"ten", (Object)10).put((Object)"eleven", (Object)11).put((Object)"twelve", (Object)12).put((Object)"thirteen", (Object)13).put((Object)"fourteen", (Object)14).put((Object)"fifteen", (Object)15).put((Object)"sixteen", (Object)16).put((Object)"seventeen", (Object)17).put((Object)"eighteen", (Object)18).put((Object)"nineteen", (Object)19).put((Object)"twenty", (Object)20).put((Object)"twenty-one", (Object)21).put((Object)"twenty-two", (Object)22).put((Object)"twenty-three", (Object)23).put((Object)"twenty-four", (Object)24).put((Object)"twenty-five", (Object)25).put((Object)"twenty-six", (Object)26).put((Object)"twenty-seven", (Object)27).put((Object)"twenty-eight", (Object)28).put((Object)"twenty-nine", (Object)29).put((Object)"thirty", (Object)30).put((Object)"thirty-one", (Object)31).put((Object)"thirty-two", (Object)32).put((Object)"thirty-three", (Object)33).put((Object)"thirty-four", (Object)34).put((Object)"thirty-five", (Object)35).put((Object)"thirty-six", (Object)36).put((Object)"thirty-seven", (Object)37).put((Object)"thirty-eight", (Object)38).put((Object)"thirty-nine", (Object)39).put((Object)"forty", (Object)40).build();
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private EssencePouchOverlay essencePouchOverlay;
    private final Deque<ClickOperation> clickedItems = new ArrayDeque<ClickOperation>();
    private final Deque<ClickOperation> checkedPouches = new ArrayDeque<ClickOperation>();
    private int lastEssence;
    private int lastSpace;
    private boolean gotrStarted;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.essencePouchOverlay);
        for (Pouch pouch : Pouch.values()) {
            pouch.setHolding(0);
            pouch.setUnknown(true);
            pouch.degrade(false);
        }
        this.lastSpace = -1;
        this.lastEssence = -1;
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.essencePouchOverlay);
    }

    private ClickOperation popFirstValidCheckedPouch() {
        ClickOperation op = this.checkedPouches.pollFirst();
        while (op != null && op.tick < this.client.getTickCount()) {
            op = this.checkedPouches.pollFirst();
        }
        return op;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().contains("The rift becomes active!")) {
            this.gotrStarted = true;
            for (Pouch pouch : Pouch.values()) {
                pouch.setHolding(0);
                pouch.setUnknown(false);
            }
        }
        if (!this.checkedPouches.isEmpty()) {
            if (event.getMessage().equals(POUCH_ADD_FULL_MESSAGE)) {
                ClickOperation op = this.popFirstValidCheckedPouch();
                if (op != null && op.delta == 1) {
                    Pouch pouch = op.pouch;
                    pouch.setHolding(pouch.getHoldAmount());
                    pouch.setUnknown(false);
                }
            } else {
                Matcher matcher = POUCH_CHECK_MESSAGE.matcher(event.getMessage());
                if (matcher.matches()) {
                    int num = (Integer)TEXT_TO_NUMBER.get((Object)matcher.group(1));
                    ClickOperation op = this.popFirstValidCheckedPouch();
                    if (op != null && (op.delta == 0 || op.delta == -1 && num == 0)) {
                        Pouch pouch;
                        pouch = op.pouch;
                        pouch.setHolding(num);
                        pouch.setUnknown(false);
                    }
                }
            }
        }
    }

    public boolean isInGotr() {
        Widget gotrWidget = this.client.getWidget(48889876);
        return gotrWidget != null;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        Pouch pouch;
        if (InventoryID.INVENTORY.getId() != event.getContainerId()) {
            return;
        }
        if (this.gotrStarted && !this.isInGotr()) {
            this.gotrStarted = false;
            for (Pouch pouch2 : Pouch.values()) {
                pouch2.setHolding(0);
                pouch2.setUnknown(false);
            }
        }
        Item[] items = event.getItemContainer().getItems();
        int newEss = 0;
        int newSpace = 0;
        block7: for (Item item : items) {
            switch (item.getId()) {
                case 7936: 
                case 24704: 
                case 26879: {
                    ++newEss;
                    continue block7;
                }
                case -1: {
                    ++newSpace;
                    continue block7;
                }
                case 5510: 
                case 5512: 
                case 5514: 
                case 26784: {
                    pouch = Pouch.forItem(item.getId());
                    pouch.degrade(false);
                    continue block7;
                }
                case 5511: 
                case 5513: 
                case 5515: 
                case 26786: {
                    pouch = Pouch.forItem(item.getId());
                    pouch.degrade(true);
                }
            }
        }
        if (items.length < 28) {
            newSpace += 28 - items.length;
        }
        if (this.clickedItems.isEmpty()) {
            this.lastSpace = newSpace;
            this.lastEssence = newEss;
            return;
        }
        if (this.lastEssence == -1 || this.lastSpace == -1) {
            this.lastSpace = newSpace;
            this.lastEssence = newEss;
            this.clickedItems.clear();
            return;
        }
        int tick = this.client.getTickCount();
        int essence = this.lastEssence;
        int space = this.lastSpace;
        log.debug("Begin processing {} events, last ess: {} space: {}, cur ess {}: space {}", new Object[]{this.clickedItems.size(), this.lastEssence, this.lastSpace, newEss, newSpace});
        while (essence != newEss) {
            ClickOperation op = this.clickedItems.poll();
            if (op == null) {
                log.debug("Ran out of updates while trying to balance essence!");
                break;
            }
            if (tick > op.tick) {
                log.debug("Click op timed out");
                continue;
            }
            pouch = op.pouch;
            boolean fill = op.delta > 0;
            int required = fill ? pouch.getRemaining() : pouch.getHolding();
            int essenceGot = op.delta * Math.min(required, fill ? essence : space);
            if (pouch.isUnknown() && (fill ? essence : space) >= pouch.getHoldAmount()) {
                pouch.setUnknown(false);
            }
            log.debug("{}: {}", (Object)pouch.name(), (Object)essenceGot);
            essence -= essenceGot;
            space += essenceGot;
            pouch.addHolding(essenceGot);
        }
        if (!this.clickedItems.isEmpty()) {
            log.debug("End processing with {} events left", (Object)this.clickedItems.size());
        }
        this.lastSpace = newSpace;
        this.lastEssence = newEss;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int itemId = -1;
        switch (event.getMenuAction()) {
            case ITEM_FIRST_OPTION: 
            case ITEM_SECOND_OPTION: 
            case ITEM_THIRD_OPTION: 
            case ITEM_FOURTH_OPTION: 
            case ITEM_FIFTH_OPTION: 
            case GROUND_ITEM_THIRD_OPTION: {
                itemId = event.getId();
                break;
            }
            case CC_OP: 
            case CC_OP_LOW_PRIORITY: {
                int widgetId = event.getWidgetId();
                Widget widget = this.client.getWidget(WidgetInfo.TO_GROUP((int)widgetId), WidgetInfo.TO_CHILD((int)widgetId));
                if (widget == null) break;
                int child = event.getActionParam();
                if (child == -1) {
                    return;
                }
                if ((widget = widget.getChild(child)) == null) break;
                itemId = widget.getItemId();
                break;
            }
            default: {
                return;
            }
        }
        if (itemId == -1) {
            return;
        }
        Pouch pouch = Pouch.forItem(itemId);
        if (pouch == null) {
            return;
        }
        int tick = this.client.getTickCount() + 3;
        switch (event.getMenuOption()) {
            case "Fill": {
                this.clickedItems.add(new ClickOperation(pouch, tick, 1));
                this.checkedPouches.add(new ClickOperation(pouch, tick, 1));
                break;
            }
            case "Empty": {
                this.clickedItems.add(new ClickOperation(pouch, tick, -1));
                this.checkedPouches.add(new ClickOperation(pouch, tick, -1));
                break;
            }
            case "Check": {
                this.checkedPouches.add(new ClickOperation(pouch, tick));
                break;
            }
            case "Take": {
                pouch.setHolding(0);
            }
        }
    }
}

