/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.sulliuscep;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.TileObject;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import tictac7x.sulliuscep.SulliuscepConfig;
import tictac7x.sulliuscep.TarSwamp;
import tictac7x.sulliuscep.WorldLocationObject;

public class TarSwampOverlay
extends Overlay {
    private final SulliuscepConfig config;
    private final TarSwamp tar_swamp;
    private final Set<GameObject> obstacles = new HashSet<GameObject>();
    private final Set<GameObject> sulliusceps = new HashSet<GameObject>();
    private Optional<GameObject> pit = Optional.empty();

    public TarSwampOverlay(SulliuscepConfig config, TarSwamp tar_swamp) {
        this.config = config;
        this.tar_swamp = tar_swamp;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public void onGameObjectSpawned(GameObject game_object) {
        if (!this.tar_swamp.inRegion()) {
            return;
        }
        int id = game_object.getId();
        if (this.tar_swamp.isSulliuscep(id)) {
            this.sulliusceps.add(game_object);
        } else if (this.tar_swamp.isPit(id)) {
            this.pit = Optional.of(game_object);
        } else {
            this.tar_swamp.getObstacles().stream().filter(obstacle -> game_object.getId() == obstacle.id && game_object.getWorldLocation().getX() == obstacle.x && game_object.getWorldLocation().getY() == obstacle.y).findFirst().ifPresent(obstacle -> this.obstacles.add(game_object));
        }
    }

    public void onGameObjectDespawned(GameObject game_object) {
        if (!this.tar_swamp.inRegion()) {
            return;
        }
        int id = game_object.getId();
        if (this.tar_swamp.isSulliuscep(id)) {
            this.sulliusceps.remove(game_object);
        } else if (this.tar_swamp.isPit(id)) {
            this.pit = Optional.empty();
        } else {
            this.obstacles.remove(game_object);
        }
    }

    public void onGameStateChanged(GameStateChanged event) {
        if (this.tar_swamp.inRegion() && event.getGameState() == GameState.LOADING) {
            this.obstacles.clear();
            this.sulliusceps.clear();
            this.pit = Optional.empty();
        }
    }

    private Optional<GameObject> getSulliuscep() {
        WorldLocationObject world_location_sulliuscep = this.tar_swamp.getSulliusceps().get(this.tar_swamp.getSulliuscepActive());
        return this.sulliusceps.stream().filter(sulliuscep_game_object -> sulliuscep_game_object.getWorldLocation().getX() == world_location_sulliuscep.x && sulliuscep_game_object.getWorldLocation().getY() == world_location_sulliuscep.y).findFirst();
    }

    private Set<GameObject> getObstacles() {
        switch (this.config.highlightObstacles()) {
            case NONE: {
                return new HashSet<GameObject>();
            }
            default: {
                return this.obstacles;
            }
            case NEXT: 
        }
        HashSet<GameObject> obstacles_next = new HashSet<GameObject>();
        for (GameObject obstacle : this.obstacles) {
            this.tar_swamp.getObstacles().stream().filter(world_location_obstacle -> obstacle.getWorldLocation().getX() == world_location_obstacle.x && obstacle.getWorldLocation().getY() == world_location_obstacle.y && this.tar_swamp.getSulliuscepActive() == world_location_obstacle.sulliuscep).findFirst().ifPresent(obs -> obstacles_next.add(obstacle));
        }
        return obstacles_next;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.tar_swamp.inRegion()) {
            return null;
        }
        Optional<GameObject> sulliuscep = this.getSulliuscep();
        if (sulliuscep.isPresent()) {
            this.renderClickbox(graphics, (TileObject)sulliuscep.get(), this.config.getSulliuscepColor());
        }
        if (this.pit.isPresent() && !this.tar_swamp.isPitFilled()) {
            this.renderClickbox(graphics, (TileObject)this.pit.get(), this.config.getMudPitColor());
        }
        for (GameObject obstacle : this.getObstacles()) {
            this.renderClickbox(graphics, (TileObject)obstacle, this.config.getObstaclesColor());
        }
        return null;
    }

    private void renderClickbox(Graphics2D graphics, TileObject object, Color color) {
        try {
            Shape clickbox = object.getClickbox();
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() + 30));
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.draw(clickbox);
            graphics.setColor(color);
            graphics.fill(clickbox);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

