/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.sulliuscep;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import tictac7x.sulliuscep.WorldLocationObject;
import tictac7x.sulliuscep.WorldLocationObstacle;

public class TarSwamp {
    public static final int SULLIUSCEP_0 = 31420;
    public static final int SULLIUSCEP_1 = 31421;
    public static final int SULLIUSCEP_2 = 31422;
    public static final int SULLIUSCEP_3 = 31423;
    public static final int SULLIUSCEP_4 = 31424;
    public static final int SULLIUSCEP_5 = 31425;
    public static final int PIT = 31426;
    public static final int VINES = 30644;
    public static final int THICK_VINE = 30646;
    public static final int THICK_VINES = 30648;
    public static final int VARBIT_SULLIUSCEP = 5808;
    public static final int VARBIT_PIT_FILLED = 5809;
    private final Set<Integer> regions = ImmutableSet.of((Object)14649, (Object)14650, (Object)14651, (Object)14652);
    private final List<WorldLocationObstacle> obstacles = Arrays.asList(new WorldLocationObstacle(30646, 3678, 3743, 1), new WorldLocationObstacle(30648, 3669, 3746, 2), new WorldLocationObstacle(30648, 3671, 3760, 2), new WorldLocationObstacle(30648, 3672, 3764, 2), new WorldLocationObstacle(30644, 3674, 3771, 3), new WorldLocationObstacle(30648, 3666, 3788, 4), new WorldLocationObstacle(30648, 3670, 3792, 4), new WorldLocationObstacle(30646, 3672, 3801, 4));
    private final List<WorldLocationObject> sulliusceps = Arrays.asList(new WorldLocationObject(31420, 3683, 3758), new WorldLocationObject(31421, 3678, 3733), new WorldLocationObject(31422, 3683, 3775), new WorldLocationObject(31423, 3663, 3781), new WorldLocationObject(31424, 3663, 3802), new WorldLocationObject(31425, 3678, 3806));
    private final Client client;
    private boolean in_region = false;
    private boolean pit_filled = false;
    private int sulliuscep_active = 0;

    public TarSwamp(Client client) {
        this.client = client;
    }

    public void onVarbitChanged() {
        this.pit_filled = this.client.getVarbitValue(5809) == 1;
        this.sulliuscep_active = this.client.getVarbitValue(5808);
    }

    public void onGameStateChanged(GameStateChanged event) {
        if (this.client.getMapRegions() == null) {
            return;
        }
        for (int region : this.client.getMapRegions()) {
            if (!this.regions.contains(region)) continue;
            this.in_region = true;
            return;
        }
        this.in_region = false;
    }

    public List<WorldLocationObstacle> getObstacles() {
        return this.obstacles;
    }

    public List<WorldLocationObject> getSulliusceps() {
        return this.sulliusceps;
    }

    public int getSulliuscepActive() {
        return this.sulliuscep_active;
    }

    public boolean isSulliuscep(int id) {
        return id == 31420 || id == 31421 || id == 31422 || id == 31423 || id == 31424 || id == 31425;
    }

    public boolean isPit(int id) {
        return id == 31426;
    }

    public boolean isPitFilled() {
        return this.pit_filled;
    }

    public boolean inRegion() {
        return this.in_region;
    }
}

