/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.sulliuscep;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tictac7x.sulliuscep.SulliuscepConfig;
import tictac7x.sulliuscep.TarSwamp;
import tictac7x.sulliuscep.TarSwampOverlay;
import tictac7x.sulliuscep.TarSwampWidget;

@PluginDescriptor(name="Sulliuscep run", description="Helpful clickboxes for sulliuscep run", tags={"fossil", "sullius", "sulliuscep", "numulite", "tar", "swamp"})
public class SulliuscepPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SulliuscepPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread client_thread;
    @Inject
    private SulliuscepConfig config;
    @Inject
    private OverlayManager overlays;
    private TarSwamp tar_swamp;
    private TarSwampOverlay tar_swamp_overlay;
    private TarSwampWidget tar_swamp_widget;

    @Provides
    SulliuscepConfig provideConfig(ConfigManager configManager) {
        return (SulliuscepConfig)configManager.getConfig(SulliuscepConfig.class);
    }

    protected void startUp() {
        this.tar_swamp = new TarSwamp(this.client);
        this.tar_swamp_overlay = new TarSwampOverlay(this.config, this.tar_swamp);
        this.tar_swamp_widget = new TarSwampWidget(this.config, this.tar_swamp);
        this.overlays.add((Overlay)this.tar_swamp_overlay);
        this.overlays.add((Overlay)this.tar_swamp_widget);
    }

    protected void shutDown() {
        this.overlays.remove((Overlay)this.tar_swamp_overlay);
        this.overlays.remove((Overlay)this.tar_swamp_widget);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.tar_swamp_overlay.onGameObjectSpawned(event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.tar_swamp_overlay.onGameObjectDespawned(event.getGameObject());
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.tar_swamp.onVarbitChanged();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.tar_swamp.onGameStateChanged(event);
        this.tar_swamp_overlay.onGameStateChanged(event);
    }
}

