/*
 * Decompiled with CFR 0.152.
 */
package dev.dkvl.largelogout;

import com.google.inject.Provides;
import dev.dkvl.largelogout.LargeLogoutConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Large Logout")
public class LargeLogoutPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LargeLogoutPlugin.class);
    private static final int ORIG_CORNER_SIDE = 36;
    private static final int ORIG_BUTTONS_PANE_HEIGHT = 132;
    private static final int ORIG_BUTTONS_PANE_Y_OFFSET = 16;
    private static final int ORIG_LOGOUT_BUTTON_WIDTH = 144;
    private static final int ORIG_LOGOUT_BUTTON_HEIGHT = 36;
    private static final int WIDGET_SPACING = 10;
    private static final int SCRIPT_LOGOUT_LAYOUT_UPDATE = 2243;
    private static final int WIDGET_LOGOUT_LAYOUT = LargeLogoutPlugin.PACK(182, 0);
    private static final int WIDGET_BUTTON_PANE = LargeLogoutPlugin.PACK(182, 1);
    private static final int WIDGET_INFO_TEXT = LargeLogoutPlugin.PACK(182, 2);
    private static final int WIDGET_SWITCH_BUTTON = LargeLogoutPlugin.PACK(182, 3);
    private static final int WIDGET_LOGOUT_BUTTON = LargeLogoutPlugin.PACK(182, 8);
    private static final int WIDGET_REVIEW_PANE = LargeLogoutPlugin.PACK(182, 13);
    @Inject
    private Client client;
    @Inject
    private LargeLogoutConfig config;
    @Inject
    private ClientThread clientThread;

    protected void startUp() throws Exception {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invokeLater(this::enlargeLogoutButton);
        }
    }

    protected void shutDown() throws Exception {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invokeLater(this::restoreLogoutLayout);
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 2243) {
            this.enlargeLogoutButton();
        }
    }

    private void restoreLogoutLayout() {
        if (this.client.getWidget(WIDGET_LOGOUT_LAYOUT) == null) {
            return;
        }
        this.client.getWidget(WIDGET_REVIEW_PANE).setHidden(false);
        this.client.getWidget(WIDGET_INFO_TEXT).setHidden(false);
        this.client.getWidget(WIDGET_BUTTON_PANE).setHeightMode(0).setOriginalHeight(132).setYPositionMode(2).setOriginalY(16).revalidate();
        this.client.getWidget(WIDGET_SWITCH_BUTTON).setYPositionMode(1).setOriginalY(0).revalidate();
        Widget logoutButton = this.client.getWidget(WIDGET_LOGOUT_BUTTON);
        logoutButton.setYPositionMode(2).setHeightMode(0).setOriginalHeight(36).setWidthMode(0).setOriginalWidth(144).revalidate();
        this.scaleButton(logoutButton, 36);
    }

    private void enlargeLogoutButton() {
        if (this.client.getWidget(WIDGET_LOGOUT_LAYOUT) == null) {
            return;
        }
        this.client.getWidget(WIDGET_REVIEW_PANE).setHidden(true);
        this.client.getWidget(WIDGET_INFO_TEXT).setHidden(true);
        this.fillParentWith(this.client.getWidget(WIDGET_BUTTON_PANE));
        this.client.getWidget(WIDGET_SWITCH_BUTTON).setYPositionMode(0).setOriginalY(10).revalidate();
        Widget logoutButton = this.client.getWidget(WIDGET_LOGOUT_BUTTON);
        logoutButton.setYPositionMode(2).setHeightMode(1).setOriginalHeight(56).setWidthMode(1).setOriginalWidth(0).revalidate();
        this.scaleButton(logoutButton, logoutButton.getWidth() * 5 / 6);
    }

    private void fillParentWith(Widget w) {
        w.setHeightMode(1).setOriginalHeight(0).setWidthMode(1).setOriginalWidth(0).setOriginalX(0).setOriginalY(0).revalidate();
    }

    private void scaleButton(Widget button, int cornerWidth) {
        Widget[] children = button.getStaticChildren();
        Widget middle = children[0];
        Widget left = children[1];
        Widget right = children[2];
        Widget textbox = children[3];
        middle.setHeightMode(0).setYPositionMode(1).revalidate();
        this.fillParentWith(textbox);
        this.stretchCorner(left, cornerWidth, 0);
        this.stretchCorner(right, cornerWidth, 2);
    }

    private void stretchCorner(Widget corner, int width, int positionMode) {
        corner.setXPositionMode(positionMode).setOriginalX(0).setHeightMode(1).setOriginalHeight(0).setWidthMode(0).setOriginalWidth(width).setSpriteTiling(false).revalidate();
    }

    private static int PACK(int groupId, int childId) {
        return groupId << 16 | childId;
    }

    @Provides
    LargeLogoutConfig provideConfig(ConfigManager configManager) {
        return (LargeLogoutConfig)configManager.getConfig(LargeLogoutConfig.class);
    }
}

