/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.balloon;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tictac7x.balloon.Balloon;
import tictac7x.balloon.BalloonConfig;
import tictac7x.balloon.BalloonInfoBox;
import tictac7x.balloon.BalloonStorage;

@PluginDescriptor(name="Balloon Transport System", description="Show amount of logs stored in the balloon transport system storages.", tags={"balloon", "transport", "logs", "storage"})
public class TicTac7xBalloonPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TicTac7xBalloonPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlays;
    @Inject
    private ConfigManager configs;
    @Inject
    private InfoBoxManager infoboxes;
    @Inject
    private ClientThread client_thread;
    @Inject
    private ItemManager items;
    @Inject
    private BalloonConfig config;
    private Balloon balloon;
    private BalloonStorage balloon_storage;
    private BalloonInfoBox[] balloon_infoboxes;

    @Provides
    BalloonConfig provideConfig(ConfigManager configManager) {
        return (BalloonConfig)configManager.getConfig(BalloonConfig.class);
    }

    protected void startUp() {
        this.balloon = new Balloon();
        this.balloon_storage = new BalloonStorage(this.client, this.client_thread, this.configs);
        for (BalloonInfoBox infobox : this.balloon_infoboxes = new BalloonInfoBox[]{new BalloonInfoBox(1511, "logs_regular", "Regular logs - Entrana / Taverley", this.configs, this.config, this.items, this.balloon, this), new BalloonInfoBox(1521, "logs_oak", "Oak logs - Crafting Guild", this.configs, this.config, this.items, this.balloon, this), new BalloonInfoBox(1519, "logs_willow", "Willow logs - Varrock", this.configs, this.config, this.items, this.balloon, this), new BalloonInfoBox(1515, "logs_yew", "Yew logs - Castle Wars", this.configs, this.config, this.items, this.balloon, this), new BalloonInfoBox(1513, "logs_magic", "Magic logs - Grand Tree", this.configs, this.config, this.items, this.balloon, this)}) {
            this.infoboxes.addInfoBox((InfoBox)infobox);
        }
    }

    protected void shutDown() {
        for (BalloonInfoBox infobox : this.balloon_infoboxes) {
            this.infoboxes.removeInfoBox((InfoBox)infobox);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        this.balloon_storage.onChatMessage(event);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        this.balloon_storage.onWidgetLoaded(event);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.balloon.onGameObjectSpawned(event);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.balloon.onGameStateChanged(event);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        for (BalloonInfoBox infobox : this.balloon_infoboxes) {
            infobox.onConfigChanged(event);
        }
    }
}

