/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.balloon;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;

public class BalloonStorage {
    private static final int WIDGET_CHECK_PARENT_ID = 229;
    private static final int WIDGET_CHECK_CHILD_ID = 1;
    private static final int WIDGET_STORE_PARENT_ID = 193;
    private static final int WIDGET_STORE_CHILD_ID = 2;
    private final Pattern regex_left_plural = Pattern.compile("You have (?<count>.+) sets of (?<type>.*) left in storage.");
    private final Pattern regex_left_singular = Pattern.compile("You have one set of (?<type>.*) left in storage.");
    private final Pattern regex_last = Pattern.compile("You used the last of your (?<type>.*).");
    private final Pattern regex_store = Pattern.compile("You put the (.*) in the crate. You now have (?<count>.+) stored.");
    private final Pattern regex_needed = Pattern.compile("You need 1 (?<type>.*) logs to make this trip.");
    private final Pattern regex_check = Pattern.compile("This crate currently contains (?<regular>.+) logs, (?<oak>.+) oak logs, (?<willow>.+) willow logs, (?<yew>.+) yew logs and (?<magic>.+) magic logs.");
    private final Client client;
    private final ClientThread client_thread;
    private final ConfigManager configs;

    public BalloonStorage(Client client, ClientThread client_thread, ConfigManager configs) {
        this.client = client;
        this.client_thread = client_thread;
        this.configs = configs;
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 229) {
            this.client_thread.invokeLater(() -> {
                Widget widget = this.client.getWidget(229, 1);
                if (widget == null) {
                    return;
                }
                String message = widget.getText().replaceAll("<br>", " ");
                this.updateLogsCountFromCheckMessage(message);
                this.updateLogsCountFromNeededMessage(message);
            });
        } else if (event.getGroupId() == 193) {
            this.client_thread.invokeLater(() -> {
                Widget widget = this.client.getWidget(193, 2);
                if (widget == null) {
                    return;
                }
                String message = widget.getText().replaceAll("<br>", " ");
                this.updateLogsCountFromStoreMessage(message);
            });
        }
    }

    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM) {
            return;
        }
        this.updateLogsCountFromLeftPluralMessage(event.getMessage());
        this.updateLogsCountFromLeftSingularMessage(event.getMessage());
        this.updateLogsCountFromLastMessage(event.getMessage());
    }

    private void updateLogsCountFromLeftPluralMessage(String message) {
        Matcher matcher = this.regex_left_plural.matcher(message);
        if (!matcher.find()) {
            return;
        }
        String type = matcher.group("type");
        int count = Integer.parseInt(matcher.group("count"));
        this.saveLogsCountBasedOnType(type, count);
    }

    private void updateLogsCountFromLeftSingularMessage(String message) {
        Matcher matcher = this.regex_left_singular.matcher(message);
        if (!matcher.find()) {
            return;
        }
        String type = matcher.group("type");
        this.saveLogsCountBasedOnType(type, 1);
    }

    private void updateLogsCountFromLastMessage(String message) {
        Matcher matcher = this.regex_last.matcher(message);
        if (!matcher.find()) {
            return;
        }
        String type = matcher.group("type");
        this.saveLogsCountBasedOnType(type, 0);
    }

    private void updateLogsCountFromCheckMessage(String message) {
        Matcher matcher = this.regex_check.matcher(message);
        if (!matcher.find()) {
            return;
        }
        int logs_regular = Integer.parseInt(matcher.group("regular"));
        int logs_oak = Integer.parseInt(matcher.group("oak"));
        int logs_willow = Integer.parseInt(matcher.group("willow"));
        int logs_yew = Integer.parseInt(matcher.group("yew"));
        int logs_magic = Integer.parseInt(matcher.group("magic"));
        this.saveLogsCountBasedOnType("normal", logs_regular);
        this.saveLogsCountBasedOnType("oak", logs_oak);
        this.saveLogsCountBasedOnType("willow", logs_willow);
        this.saveLogsCountBasedOnType("yew", logs_yew);
        this.saveLogsCountBasedOnType("magic", logs_magic);
    }

    private void updateLogsCountFromNeededMessage(String message) {
        Matcher matcher = this.regex_needed.matcher(message);
        if (!matcher.find()) {
            return;
        }
        String type = matcher.group("type");
        this.saveLogsCountBasedOnType(type, 0);
    }

    private void updateLogsCountFromStoreMessage(String message) {
        Matcher matcher = this.regex_store.matcher(message);
        if (!matcher.find()) {
            return;
        }
        String type = matcher.group("type");
        int count = Integer.parseInt(matcher.group("count"));
        this.saveLogsCountBasedOnType(type, count);
    }

    private void saveLogsCountBasedOnType(String type, int count) {
        switch (type) {
            case "Logs": 
            case "normal": {
                this.configs.setConfiguration("tictac7x-balloon", "logs_regular", (Object)count);
                break;
            }
            case "Oak logs": 
            case "oak": {
                this.configs.setConfiguration("tictac7x-balloon", "logs_oak", (Object)count);
                break;
            }
            case "Willow logs": 
            case "willow": {
                this.configs.setConfiguration("tictac7x-balloon", "logs_willow", (Object)count);
                break;
            }
            case "Yew logs": 
            case "yew": {
                this.configs.setConfiguration("tictac7x-balloon", "logs_yew", (Object)count);
                break;
            }
            case "Magic logs": 
            case "magic": {
                this.configs.setConfiguration("tictac7x-balloon", "logs_magic", (Object)count);
            }
        }
    }
}

