/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.balloon;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import tictac7x.balloon.Balloon;
import tictac7x.balloon.BalloonConfig;

public class BalloonInfoBox
extends InfoBox {
    private final ConfigManager configs;
    private final BalloonConfig config;
    private final Balloon balloon;
    private final String logs_id;
    private final String tooltip;
    private boolean render_recently = false;

    public BalloonInfoBox(int item_id, String logs_id, String tooltip, ConfigManager configs, BalloonConfig config, ItemManager items, Balloon balloon, Plugin plugin) {
        super((BufferedImage)items.getImage(item_id), plugin);
        this.configs = configs;
        this.config = config;
        this.balloon = balloon;
        this.logs_id = logs_id;
        this.tooltip = tooltip;
    }

    public String getName() {
        return super.getName() + "_" + this.logs_id;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getText() {
        return String.valueOf(this.getCount());
    }

    public Color getTextColor() {
        return this.getCount() > 0 ? Color.lightGray : Color.red;
    }

    public boolean render() {
        return this.config.show() == BalloonConfig.Show.ALL_THE_TIME || this.config.show() == BalloonConfig.Show.NEAR_THE_BALLOON && this.balloon.isVisible() || this.config.show() == BalloonConfig.Show.RECENTLY_USED && this.render_recently;
    }

    private int getCount() {
        return Integer.parseInt(this.configs.getConfiguration("tictac7x-balloon", this.logs_id));
    }

    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("tictac7x-balloon") && event.getKey().equals(this.logs_id) && this.config.show() == BalloonConfig.Show.RECENTLY_USED) {
            this.render_recently = true;
            new Thread(() -> {
                try {
                    Thread.sleep(60L * (long)this.config.showRecentlyUsedForMinutes() * 1000L);
                    this.render_recently = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
    }
}

