/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.balloon;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="tictac7x-balloon")
public interface BalloonConfig
extends Config {
    public static final String group = "tictac7x-balloon";
    @ConfigSection(name="Infoboxes", description="Infoboxes", position=1)
    public static final String infoboxes = "infoboxes";
    @ConfigSection(name="Debug", description="Debug", position=2, closedByDefault=true)
    public static final String debug = "debug";
    public static final String logs_regular = "logs_regular";
    public static final String logs_oak = "logs_oak";
    public static final String logs_willow = "logs_willow";
    public static final String logs_yew = "logs_yew";
    public static final String logs_magic = "logs_magic";

    @ConfigItem(keyName="show", name="Show", description="When to show infoboxes about balloon logs", position=1, section="infoboxes")
    default public Show show() {
        return Show.RECENTLY_USED;
    }

    @Units(value="min")
    @Range(min=1, max=60)
    @ConfigItem(keyName="recently_used", name="Recently used duration", description="Duration for how long infoboxes are visible if showing only recently used logs", position=2, section="infoboxes")
    default public int showRecentlyUsedForMinutes() {
        return 3;
    }

    @ConfigItem(keyName="logs_regular", name="Regular logs", description="Amount of regular logs", position=1, section="debug")
    default public int getLogsRegular() {
        return 0;
    }

    @ConfigItem(keyName="logs_oak", name="Oak logs", description="Amount of oak logs", position=2, section="debug")
    default public int getLogsOak() {
        return 0;
    }

    @ConfigItem(keyName="logs_willow", name="Willow logs", description="Amount of willow logs", position=3, section="debug")
    default public int getLogsWillow() {
        return 0;
    }

    @ConfigItem(keyName="logs_yew", name="Yew logs", description="Amount of yew logs", position=4, section="debug")
    default public int getLogsYew() {
        return 0;
    }

    @ConfigItem(keyName="logs_magic", name="Magic logs", description="Amount of magic logs", position=5, section="debug")
    default public int getLogsMagic() {
        return 0;
    }

    public static enum Show {
        RECENTLY_USED,
        NEAR_THE_BALLOON,
        ALL_THE_TIME;

    }
}

