/*
 * Decompiled with CFR 0.152.
 */
package com.wikiworm.inventoryvalue;

import com.google.inject.Provides;
import com.wikiworm.inventoryvalue.InventoryValueConfig;
import com.wikiworm.inventoryvalue.InventoryValueOverlay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.item.ItemPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inventory Value")
public class InventoryValuePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InventoryValuePlugin.class);
    private static final int NUM_SLOTS = 4;
    private static final int[] AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
    private static final int[] RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};
    @Inject
    private Client client;
    @Inject
    private InventoryValueConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private InventoryValueOverlay overlay;
    private HashMap<ItemPrice, Integer> _herbs = new HashMap();
    private HashMap<ItemPrice, Integer> _gems = new HashMap();
    private HashMap<ItemPrice, Integer> _seeds = new HashMap();
    private long _oldInventoryValue = Long.MIN_VALUE;
    private long _oldProfitInvValue = Long.MIN_VALUE;
    private long _originalBankValue = Long.MIN_VALUE;
    private long _lastBankValue = Long.MIN_VALUE;
    private HashMap<String, ItemPrice> _gemLookup = new HashMap();
    private boolean _depositing = false;
    private long _preDepositInventoryValue = 0L;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this._gemLookup.put("Sapphires", (ItemPrice)this.itemManager.search("Uncut sapphire").get(0));
        this._gemLookup.put("Emeralds", (ItemPrice)this.itemManager.search("Uncut emerald").get(0));
        this._gemLookup.put("Rubies", (ItemPrice)this.itemManager.search("Uncut ruby").get(0));
        this._gemLookup.put("Diamonds", (ItemPrice)this.itemManager.search("Uncut diamond").get(0));
        this._gemLookup.put("Dragonstones", (ItemPrice)this.itemManager.search("Uncut dragonstone").get(0));
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        this.updateInventoryValue(event);
    }

    public void updateInventoryValue(ItemContainerChanged event) {
        boolean banking = event.getContainerId() == InventoryID.BANK.getId();
        boolean wornChange = event.getContainerId() == InventoryID.EQUIPMENT.getId();
        this.updateInventoryValue(banking, false);
    }

    public void updateInventoryValue(boolean banking, boolean depositing) {
        Item[] items;
        long profitBankValue = 0L;
        long profitInvValue = 0L;
        long inventoryValue = 0L;
        List<String> ignoredItems = this.buildIgnoredItemsList();
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        if (container != null) {
            items = container.getItems();
            inventoryValue = Arrays.stream(items).flatMapToLong(item -> LongStream.of(this.calculateItemValue((Item)item, ignoredItems))).sum();
        }
        if (this._oldProfitInvValue == Long.MIN_VALUE) {
            profitInvValue = 0L;
        } else if (!banking && !depositing) {
            profitInvValue = inventoryValue - this._oldInventoryValue + this._oldProfitInvValue;
        }
        if (banking) {
            container = this.client.getItemContainer(InventoryID.BANK);
            if (container != null) {
                items = container.getItems();
                long bankValue = Arrays.stream(items).flatMapToLong(item -> LongStream.of(this.calculateItemValue((Item)item, ignoredItems))).sum();
                if (this._originalBankValue == Long.MIN_VALUE) {
                    this._originalBankValue = bankValue;
                }
                profitBankValue = bankValue - this._originalBankValue;
                this._lastBankValue = bankValue;
            }
        } else {
            profitBankValue = depositing && this._originalBankValue == Long.MIN_VALUE ? this._lastBankValue : (this._originalBankValue == Long.MIN_VALUE && this._lastBankValue != Long.MIN_VALUE ? this._lastBankValue : this._lastBankValue - this._originalBankValue);
        }
        this.overlay.updateInventoryValue(inventoryValue, profitInvValue, profitBankValue);
        this._oldInventoryValue = inventoryValue;
        this._oldProfitInvValue = profitInvValue;
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        Item[] items;
        ItemContainer container;
        List<String> ignoredItems;
        if (event.getId() == 6 && (event.getItemId() == 24478 || event.getItemId() == 13226)) {
            this._herbs.clear();
        }
        if (event.getId() == 6 && (event.getItemId() == 24482 || event.getItemId() == 13639)) {
            this._seeds.clear();
        }
        if (event.getId() == 6 && (event.getItemId() == 24481 || event.getItemId() == 766)) {
            this._gems.clear();
        }
        if (event.getId() == 4 && (event.getItemId() == 24478 || event.getItemId() == 13226)) {
            this._herbs.clear();
        }
        if (event.getId() == 4 && (event.getItemId() == 24482 || event.getItemId() == 13639)) {
            this._seeds.clear();
        }
        if (event.getId() == 4 && (event.getItemId() == 24481 || event.getItemId() == 766)) {
            this._gems.clear();
        }
        boolean inDepositWindow = false;
        if (event.getMenuOption().compareTo("Deposit") == 0) {
            this._depositing = true;
            inDepositWindow = true;
            ignoredItems = this.buildIgnoredItemsList();
            container = this.client.getItemContainer(InventoryID.INVENTORY);
            if (container != null) {
                items = container.getItems();
                this._preDepositInventoryValue = Arrays.stream(items).flatMapToLong(item -> LongStream.of(this.calculateItemValue((Item)item, ignoredItems))).sum();
            }
        }
        if (!event.getMenuOption().contains("Deposit") && this._depositing && !inDepositWindow) {
            this._depositing = false;
            ignoredItems = this.buildIgnoredItemsList();
            container = this.client.getItemContainer(InventoryID.INVENTORY);
            if (container != null) {
                items = container.getItems();
                long inventoryValue = Arrays.stream(items).flatMapToLong(item -> LongStream.of(this.calculateItemValue((Item)item, ignoredItems))).sum();
                long increment = this._preDepositInventoryValue - inventoryValue;
                this._lastBankValue = this._lastBankValue == Long.MIN_VALUE ? increment : (this._lastBankValue += increment);
                this.updateInventoryValue(false, true);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        String[] qtyAndSeed;
        ItemPrice price;
        List itemPrices;
        String[] qtyAndHerb;
        String messageString = chatMessage.getMessage();
        if (messageString.contains("x Grimy") && (qtyAndHerb = chatMessage.getMessage().split(" x ")).length == 2) {
            String herbName = qtyAndHerb[1].trim();
            int herbQty = Integer.parseInt(qtyAndHerb[0].trim(), 10);
            itemPrices = this.itemManager.search(herbName);
            if (itemPrices.size() == 1) {
                price = (ItemPrice)itemPrices.get(0);
                this._herbs.put(price, herbQty);
                this.updateInventoryValue(false, false);
            }
        }
        if (messageString.contains("Sapphires:") && messageString.contains("Emeralds:")) {
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(messageString.split("\\P{L}+")));
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(messageString.split("[^0-9]+")));
            keys.removeIf(str -> str.compareTo("br") == 0);
            values.removeIf(String::isEmpty);
            if (keys.size() == values.size()) {
                for (int i = 0; i < keys.size(); ++i) {
                    ItemPrice price2 = this._gemLookup.get(keys.get(i));
                    this._gems.put(price2, Integer.parseInt((String)values.get(i)));
                    this.updateInventoryValue(false, false);
                }
            }
        }
        if (messageString.contains(" x ") && messageString.contains(" seed.") && (qtyAndSeed = chatMessage.getMessage().split(" x ")).length == 2) {
            String seedName = qtyAndSeed[1].trim().replace(".", "");
            int seedQty = Integer.parseInt(qtyAndSeed[0].trim(), 10);
            itemPrices = this.itemManager.search(seedName);
            if (itemPrices.size() == 1) {
                price = (ItemPrice)itemPrices.get(0);
                this._seeds.put(price, seedQty);
                this.updateInventoryValue(false, false);
            }
        }
        if (messageString.compareTo("The herb sack is empty.") == 0) {
            this._herbs.clear();
        }
        if (messageString.compareTo("The gem bag is empty.") == 0) {
            this._gems.clear();
        }
        if (messageString.compareTo("The seed box is empty.") == 0) {
            this._seeds.clear();
        }
        if (messageString.compareTo("!Reset_iv") == 0) {
            this._oldInventoryValue = 0L;
            this._oldProfitInvValue = 0L;
            this._lastBankValue = 0L;
            this.updateInventoryValue(false, false);
        }
    }

    public List<String> buildIgnoredItemsList() {
        List<String> ignoredItemsList = Arrays.asList(this.config.ignoreItems().toLowerCase().split("[,;]"));
        ignoredItemsList.replaceAll(String::trim);
        return ignoredItemsList;
    }

    public long calculateItemValue(Item item, List<String> ignoredItems) {
        int itemId = item.getId();
        if (this.itemManager != null) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            String itemName = itemComposition.getName();
            if (itemId == 995 && this.config.ignoreCoins()) {
                return 0L;
            }
            if (itemId == 995) {
                return item.getQuantity();
            }
            if (ignoredItems.contains(itemName.toLowerCase())) {
                log.info("ignored item: " + itemName.toLowerCase());
                return 0L;
            }
            if (itemId == 12791 || itemId == 24416 || itemId == 27281 || itemId == 27509) {
                return this.handleRunePouch(item);
            }
            if (itemId == 12020 || itemId == 24481) {
                return this.handleGemBag();
            }
            if (itemId == 13226 || itemId == 24478) {
                return this.handleHerbSack();
            }
            if (itemId == 13639 || itemId == 24482) {
                return this.handleSeedBox();
            }
            return (long)item.getQuantity() * (long)(this.config.useHighAlchemyValue() ? itemComposition.getHaPrice() : this.itemManager.getItemPrice(itemId));
        }
        return 0L;
    }

    @Provides
    InventoryValueConfig provideConfig(ConfigManager configManager) {
        return (InventoryValueConfig)configManager.getConfig(InventoryValueConfig.class);
    }

    private long handleRunePouch(Item runePouch) {
        EnumComposition runepouchEnum = this.client.getEnum(982);
        boolean num = false;
        long totalValue = 0L;
        for (int i = 0; i < 4; ++i) {
            int amountVarbit = AMOUNT_VARBITS[i];
            int amount = this.client.getVarbitValue(amountVarbit);
            int runeVarbit = RUNE_VARBITS[i];
            int runeId = this.client.getVarbitValue(runeVarbit);
            int itemId = runepouchEnum.getIntValue(runeId);
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            totalValue += (long)amount * (long)(this.config.useHighAlchemyValue() ? itemComposition.getHaPrice() : this.itemManager.getItemPrice(itemId));
        }
        return totalValue;
    }

    public long handleHerbSack() {
        long herbSackValue = 0L;
        for (Map.Entry<ItemPrice, Integer> entry : this._herbs.entrySet()) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(entry.getKey().getId());
            herbSackValue += (long)entry.getValue().intValue() * (long)(this.config.useHighAlchemyValue() ? itemComposition.getHaPrice() : entry.getKey().getPrice());
        }
        return herbSackValue;
    }

    public long handleGemBag() {
        long gemBagValue = 0L;
        for (Map.Entry<ItemPrice, Integer> entry : this._gems.entrySet()) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(entry.getKey().getId());
            gemBagValue += (long)entry.getValue().intValue() * (long)(this.config.useHighAlchemyValue() ? itemComposition.getHaPrice() : entry.getKey().getPrice());
        }
        return gemBagValue;
    }

    public long handleSeedBox() {
        long seedBoxValue = 0L;
        for (Map.Entry<ItemPrice, Integer> entry : this._seeds.entrySet()) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(entry.getKey().getId());
            seedBoxValue += (long)entry.getValue().intValue() * (long)(this.config.useHighAlchemyValue() ? itemComposition.getHaPrice() : entry.getKey().getPrice());
        }
        return seedBoxValue;
    }
}

