/*
 * Decompiled with CFR 0.152.
 */
package com.wikiworm.inventoryvalue;

import com.wikiworm.inventoryvalue.InventoryValueConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryValueOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(InventoryValueOverlay.class);
    private Long inventoryValue = 0L;
    private Long startingValue = Long.MIN_VALUE;
    private Long profitInvValue = 0L;
    private Long profitBankValue = 0L;
    private Color profitInvColor = Color.GREEN;
    private Color profitBankColor = Color.GREEN;
    private final InventoryValueConfig inventoryValueConfig;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private InventoryValueOverlay(InventoryValueConfig config) {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.inventoryValueConfig = config;
    }

    public Dimension render(Graphics2D graphics) {
        String titleText = "Inventory Value";
        String valueString = this.inventoryValueConfig.useHighAlchemyValue() ? "HA Price:" : "GE Price:";
        String profitInvString = "Profit (inv):";
        String profitBankString = "Profit (banked):";
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(TitleComponent.builder().text(titleText).color(Color.GREEN).build());
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(titleText) + 30, 0));
        this.panelComponent.getChildren().add(LineComponent.builder().left(valueString).leftColor(Color.WHITE).right(QuantityFormatter.quantityToStackSize((long)this.inventoryValue)).rightColor(Color.YELLOW).build());
        if (this.inventoryValueConfig.displayProfit()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(profitInvString).leftColor(Color.WHITE).right(QuantityFormatter.quantityToStackSize((long)this.profitInvValue)).rightColor(this.profitInvColor).build());
        }
        if (this.inventoryValueConfig.displayProfit()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(profitBankString).leftColor(Color.WHITE).right(QuantityFormatter.quantityToStackSize((long)this.profitBankValue)).rightColor(this.profitBankColor).build());
        }
        return this.panelComponent.render(graphics);
    }

    public void updateInventoryValue(long newInventoryValue, long newProfitInvValue, long newProfitBankValue) {
        Color updateInvProfitColor = newProfitInvValue >= 0L ? Color.GREEN : Color.RED;
        Color updateBankProfitColor = newProfitBankValue >= 0L ? Color.GREEN : Color.RED;
        SwingUtilities.invokeLater(() -> {
            this.inventoryValue = newInventoryValue;
        });
        if (this.inventoryValueConfig.displayProfit()) {
            SwingUtilities.invokeLater(() -> {
                this.profitBankValue = newProfitBankValue;
                this.profitInvValue = newProfitInvValue;
                this.profitInvColor = updateInvProfitColor;
                this.profitBankColor = updateBankProfitColor;
            });
        }
    }
}

