/*
 * Decompiled with CFR 0.152.
 */
package com.rubueno.zmi;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ZMI", description="Removes scenery from ZMI to improve performance")
public class ZmiPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ZmiPlugin.class);
    private static final Set<Integer> HIDE = ImmutableSet.of((Object)21011, (Object)21012, (Object)29630, (Object)29629, (Object)29633, (Object)29632, (Object[])new Integer[]{34780, 34781, 34794, 25052, 25087, 25088, 25089});
    private static final Set<Integer> ZmiMapRegions = ImmutableSet.of((Object)12118, (Object)12119, (Object)12374, (Object)12375);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    protected void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::hide);
        }
    }

    protected void shutDown() {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.hide();
        }
    }

    private void hide() {
        if (!this.isInZmi()) {
            return;
        }
        Scene scene = this.client.getScene();
        Tile[][] tiles = scene.getTiles()[0];
        Player player = this.client.getLocalPlayer();
        int cnt = 0;
        for (int x = 0; x < 104; ++x) {
            block1: for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[x][y];
                if (tile == null) continue;
                for (GameObject gameObject : tile.getGameObjects()) {
                    if (gameObject == null || !HIDE.contains(gameObject.getId())) continue;
                    scene.removeGameObject(gameObject);
                    ++cnt;
                    continue block1;
                }
            }
        }
        log.debug("Removed {} objects", (Object)cnt);
    }

    private boolean isInZmi() {
        Integer[] asd = ArrayUtils.toObject((int[])this.client.getMapRegions());
        HashSet<Integer> currentRegions = new HashSet<Integer>(Arrays.asList(asd));
        currentRegions.retainAll(ZmiMapRegions);
        return currentRegions.stream().count() > 0L;
    }
}

