/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easygiantsfoundry;

import com.toofifty.easygiantsfoundry.EasyGiantsFoundryConfig;
import com.toofifty.easygiantsfoundry.enums.CommissionType;
import com.toofifty.easygiantsfoundry.enums.Mould;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;

public class MouldHelper {
    static final int MOULD_LIST_PARENT = 47054857;
    static final int DRAW_MOULD_LIST_SCRIPT = 6093;
    static final int REDRAW_MOULD_LIST_SCRIPT = 6095;
    static final int RESET_MOULD_SCRIPT = 6108;
    public static final int SELECT_MOULD_SCRIPT = 6098;
    static final int SWORD_TYPE_1_VARBIT = 13907;
    static final int SWORD_TYPE_2_VARBIT = 13908;
    private static final int DISABLED_TEXT_COLOR = 0x9F9F9F;
    private static final int GREEN = 901389;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EasyGiantsFoundryConfig config;

    public void selectBest(int scriptId) {
        Widget parent = this.client.getWidget(47054857);
        if (parent == null || parent.getChildren() == null) {
            return;
        }
        Map<Mould, Widget> mouldToChild = this.getOptions(parent.getChildren());
        int bestScore = -1;
        Widget bestWidget = null;
        CommissionType type1 = CommissionType.forVarbit(this.client.getVarbitValue(13907));
        CommissionType type2 = CommissionType.forVarbit(this.client.getVarbitValue(13908));
        for (Map.Entry<Mould, Widget> entry : mouldToChild.entrySet()) {
            Mould mould = entry.getKey();
            int score = mould.getScore(type1, type2);
            if (score <= bestScore) continue;
            bestScore = score;
            bestWidget = entry.getValue();
        }
        if (bestWidget != null) {
            bestWidget.setTextColor(this.config.mouldTextColour().getRGB());
        }
        if (scriptId == 6093 || scriptId == 6095) {
            Widget scrollBar = this.client.getWidget(718, 11);
            Widget scrollList = this.client.getWidget(718, 9);
            if (scrollBar != null && scrollList != null) {
                int height = scrollList.getHeight();
                int scrollMax = scrollList.getScrollHeight();
                Widget finalBestWidget = bestWidget;
                this.clientThread.invokeLater(() -> {
                    if (finalBestWidget != null) {
                        this.client.runScript(new Object[]{72, scrollBar.getId(), scrollList.getId(), Math.min(finalBestWidget.getOriginalY() - 2, scrollMax - height)});
                    }
                });
            }
        }
    }

    private Map<Mould, Widget> getOptions(Widget[] children) {
        LinkedHashMap<Mould, Widget> mouldToChild = new LinkedHashMap<Mould, Widget>();
        for (int i = 2; i < children.length; i += 17) {
            Widget child = children[i];
            Mould mould = Mould.forName(child.getText());
            if (mould == null || child.getTextColor() == 0x9F9F9F) continue;
            mouldToChild.put(mould, child);
        }
        return mouldToChild;
    }
}

