/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easygiantsfoundry;

import com.toofifty.easygiantsfoundry.BonusWidget;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryConfig;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryHelper;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryState;
import com.toofifty.easygiantsfoundry.enums.Heat;
import com.toofifty.easygiantsfoundry.enums.Stage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;

public class FoundryOverlay3D
extends Overlay {
    private static final int HAND_IN_WIDGET = 49414221;
    GameObject tripHammer;
    GameObject grindstone;
    GameObject polishingWheel;
    GameObject lavaPool;
    GameObject waterfall;
    GameObject mouldJig;
    GameObject crucible;
    NPC kovac;
    private final Client client;
    private final EasyGiantsFoundryState state;
    private final EasyGiantsFoundryHelper helper;
    private final EasyGiantsFoundryConfig config;

    @Inject
    private FoundryOverlay3D(Client client, EasyGiantsFoundryState state, EasyGiantsFoundryHelper helper, EasyGiantsFoundryConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client;
        this.state = state;
        this.helper = helper;
        this.config = config;
    }

    private Color getObjectColor(Stage stage, Heat heat) {
        if (stage.getHeat() != heat) {
            return this.config.toolBad();
        }
        if (BonusWidget.isActive(this.client)) {
            return this.config.toolBonus();
        }
        int actionsLeft = this.helper.getActionsLeftInStage();
        int heatLeft = this.helper.getActionsForHeatLevel();
        if (actionsLeft <= 1 || heatLeft <= 1) {
            return this.config.toolCaution();
        }
        return this.config.toolGood();
    }

    private GameObject getStageObject(Stage stage) {
        switch (stage) {
            case TRIP_HAMMER: {
                return this.tripHammer;
            }
            case GRINDSTONE: {
                return this.grindstone;
            }
            case POLISHING_WHEEL: {
                return this.polishingWheel;
            }
        }
        return null;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.state.isEnabled()) {
            return null;
        }
        if (this.config.highlightKovac()) {
            this.drawKovacIfHandIn(graphics);
        }
        if (this.state.getCurrentStage() == null) {
            if (this.config.highlightMould()) {
                this.drawMouldIfNotSet(graphics);
            }
            if (this.config.highlightCrucible()) {
                this.drawCrucibleIfMouldSet(graphics);
            }
            return null;
        }
        Stage stage = this.state.getCurrentStage();
        GameObject stageObject = this.getStageObject(stage);
        if (stageObject == null) {
            return null;
        }
        Heat heat = this.state.getCurrentHeat();
        Color color = this.getObjectColor(stage, heat);
        Shape objectClickbox = stageObject.getClickbox();
        if (objectClickbox != null && this.config.highlightTools()) {
            Point mousePosition = this.client.getMouseCanvasPosition();
            if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                graphics.setColor(color.darker());
            } else {
                graphics.setColor(color);
            }
            graphics.draw(objectClickbox);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(objectClickbox);
        }
        if (stage.getHeat() != heat && this.config.highlightWaterAndLava()) {
            this.drawHeatChangers(graphics);
        }
        return null;
    }

    private void drawHeatChangers(Graphics2D graphics) {
        int change = this.state.getHeatChangeNeeded();
        Shape shape = null;
        if (change < 0) {
            shape = this.waterfall.getClickbox();
        } else if (change > 0) {
            shape = this.lavaPool.getClickbox();
        }
        if (shape != null) {
            Point mousePosition = this.client.getMouseCanvasPosition();
            Color color = this.config.lavaWaterfallColour();
            if (shape.contains(mousePosition.getX(), mousePosition.getY())) {
                graphics.setColor(color.darker());
            } else {
                graphics.setColor(color);
            }
            graphics.draw(shape);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(shape);
        }
    }

    private void drawCrucibleIfMouldSet(Graphics2D graphics) {
        if (this.client.getVarbitValue(13907) == 0) {
            return;
        }
        if (this.client.getVarbitValue(13914) != 1) {
            return;
        }
        Shape shape = this.crucible.getConvexHull();
        if (shape != null) {
            Color color = this.config.generalHighlight();
            graphics.setColor(color);
            graphics.draw(shape);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(shape);
        }
    }

    private void drawMouldIfNotSet(Graphics2D graphics) {
        if (this.client.getWidget(49414219) != null || this.client.getVarbitValue(13907) == 0 || this.client.getVarbitValue(13914) != 0 && this.client.getVarbitValue(13914) != 2) {
            return;
        }
        Shape shape = this.mouldJig.getConvexHull();
        if (shape != null) {
            Color color = this.config.generalHighlight();
            graphics.setColor(color);
            graphics.draw(shape);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(shape);
        }
    }

    private void drawKovacIfHandIn(Graphics2D graphics) {
        Shape shape;
        Widget handInWidget = this.client.getWidget(49414221);
        if (handInWidget != null && !handInWidget.isHidden() && (shape = this.kovac.getConvexHull()) != null) {
            Color color = this.config.generalHighlight();
            graphics.setColor(color);
            graphics.draw(shape);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(shape);
        }
    }
}

