/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easygiantsfoundry;

import com.toofifty.easygiantsfoundry.EasyGiantsFoundryConfig;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryHelper;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryPlugin;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryState;
import com.toofifty.easygiantsfoundry.enums.Heat;
import com.toofifty.easygiantsfoundry.enums.Stage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

@Singleton
public class FoundryOverlay2D
extends OverlayPanel {
    private static final int REGION_ID = 13491;
    private final Client client;
    private final EasyGiantsFoundryPlugin plugin;
    private final EasyGiantsFoundryState state;
    private final EasyGiantsFoundryHelper helper;
    private final EasyGiantsFoundryConfig config;

    @Inject
    private FoundryOverlay2D(Client client, EasyGiantsFoundryPlugin plugin, EasyGiantsFoundryState state, EasyGiantsFoundryHelper helper, EasyGiantsFoundryConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.state = state;
        this.helper = helper;
        this.config = config;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
    }

    private Color getHeatColor(int actions, int heat) {
        if (heat >= actions) {
            return ColorScheme.PROGRESS_COMPLETE_COLOR;
        }
        if (heat > 0) {
            return ColorScheme.PROGRESS_INPROGRESS_COLOR;
        }
        return ColorScheme.PROGRESS_ERROR_COLOR;
    }

    public Dimension render(Graphics2D graphics) {
        boolean swordPickedUp;
        if (this.client.getLocalPlayer().getWorldLocation().getRegionID() != 13491) {
            return null;
        }
        boolean bl = swordPickedUp = this.state.isEnabled() && this.state.getCurrentStage() != null;
        if (this.config.drawTitle()) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Easy Giant's Foundry").build());
        }
        if (swordPickedUp) {
            Heat heat = this.state.getCurrentHeat();
            Stage stage = this.state.getCurrentStage();
            if (this.config.drawHeatInfo()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Heat").right(heat.getName() + " (" + this.state.getHeatAmount() / 10 + "%)").rightColor(heat.getColor()).build());
            }
            if (this.config.drawStageInfo()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Stage").right(stage.getName() + " (" + this.state.getProgressAmount() / 10 + "%)").rightColor(stage.getHeat().getColor()).build());
            }
            int actionsLeft = this.helper.getActionsLeftInStage();
            int heatLeft = this.helper.getActionsForHeatLevel();
            if (this.config.drawActionsLeft()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Actions left").right("" + actionsLeft).build());
            }
            if (this.config.drawHeatLeft()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Heat left").right("" + heatLeft).rightColor(this.getHeatColor(actionsLeft, heatLeft)).build());
            }
        }
        if (this.config.drawShopPoints()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Reputation").right("" + this.plugin.getReputation()).build());
        }
        return super.render(graphics);
    }
}

