/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easygiantsfoundry;

import com.toofifty.easygiantsfoundry.enums.Heat;
import com.toofifty.easygiantsfoundry.enums.Stage;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;

@Singleton
public class EasyGiantsFoundryState {
    private static final int VARBIT_HEAT = 13948;
    private static final int VARBIT_PROGRESS = 13949;
    private static final int VARBIT_ORE_COUNT = 13934;
    private static final int VARBIT_FORTE_SELECTED = 13910;
    private static final int VARBIT_BLADE_SELECTED = 13911;
    private static final int VARBIT_TIP_SELECTED = 13912;
    static final int VARBIT_GAME_STAGE = 13914;
    private static final int WIDGET_HEAT_PARENT = 49414153;
    private static final int WIDGET_LOW_HEAT_PARENT = 49414163;
    private static final int WIDGET_MED_HEAT_PARENT = 49414164;
    private static final int WIDGET_HIGH_HEAT_PARENT = 49414165;
    static final int WIDGET_PROGRESS_PARENT = 49414219;
    private static final int SPRITE_ID_TRIP_HAMMER = 4442;
    private static final int SPRITE_ID_GRINDSTONE = 4443;
    private static final int SPRITE_ID_POLISHING_WHEEL = 4444;
    @Inject
    private Client client;
    private boolean enabled;
    private final List<Stage> stages = new ArrayList<Stage>();
    private double heatRangeRatio = 0.0;

    public void reset() {
        this.stages.clear();
        this.heatRangeRatio = 0.0;
    }

    public int getHeatAmount() {
        return this.client.getVarbitValue(13948);
    }

    public int getProgressAmount() {
        return this.client.getVarbitValue(13949);
    }

    public double getHeatRangeRatio() {
        if (this.heatRangeRatio == 0.0) {
            Widget heatWidget = this.client.getWidget(49414153);
            Widget medHeat = this.client.getWidget(49414164);
            if (medHeat == null || heatWidget == null) {
                return 0.0;
            }
            this.heatRangeRatio = (double)medHeat.getWidth() / (double)heatWidget.getWidth();
        }
        return this.heatRangeRatio;
    }

    public int[] getLowHeatRange() {
        return new int[]{(int)((0.16666666666666666 - this.getHeatRangeRatio() / 2.0) * 1000.0), (int)((0.16666666666666666 + this.getHeatRangeRatio() / 2.0) * 1000.0)};
    }

    public int[] getMedHeatRange() {
        return new int[]{(int)((0.5 - this.getHeatRangeRatio() / 2.0) * 1000.0), (int)((0.5 + this.getHeatRangeRatio() / 2.0) * 1000.0)};
    }

    public int[] getHighHeatRange() {
        return new int[]{(int)((0.8333333333333334 - this.getHeatRangeRatio() / 2.0) * 1000.0), (int)((0.8333333333333334 + this.getHeatRangeRatio() / 2.0) * 1000.0)};
    }

    public List<Stage> getStages() {
        if (this.stages.isEmpty()) {
            Widget progressParent = this.client.getWidget(49414219);
            if (progressParent == null || progressParent.getChildren() == null) {
                return new ArrayList<Stage>();
            }
            block5: for (Widget child : progressParent.getChildren()) {
                switch (child.getSpriteId()) {
                    case 4442: {
                        this.stages.add(Stage.TRIP_HAMMER);
                        continue block5;
                    }
                    case 4443: {
                        this.stages.add(Stage.GRINDSTONE);
                        continue block5;
                    }
                    case 4444: {
                        this.stages.add(Stage.POLISHING_WHEEL);
                    }
                }
            }
        }
        return this.stages;
    }

    public Stage getCurrentStage() {
        int index = (int)((double)this.getProgressAmount() / 1000.0 * (double)this.getStages().size());
        if (index < 0 || index > this.getStages().size() - 1) {
            return null;
        }
        return this.getStages().get(index);
    }

    public Heat getCurrentHeat() {
        int[] low;
        int heat = this.getHeatAmount();
        if (heat > (low = this.getLowHeatRange())[0] && heat < low[1]) {
            return Heat.LOW;
        }
        int[] med = this.getMedHeatRange();
        if (heat > med[0] && heat < med[1]) {
            return Heat.MED;
        }
        int[] high = this.getHighHeatRange();
        if (heat > high[0] && heat < high[1]) {
            return Heat.HIGH;
        }
        return Heat.NONE;
    }

    public int getHeatChangeNeeded() {
        int[] range;
        Heat requiredHeat = this.getCurrentStage().getHeat();
        int heat = this.getHeatAmount();
        switch (requiredHeat) {
            case LOW: {
                range = this.getLowHeatRange();
                break;
            }
            case MED: {
                range = this.getMedHeatRange();
                break;
            }
            case HIGH: {
                range = this.getHighHeatRange();
                break;
            }
            default: {
                return 0;
            }
        }
        if (heat < range[0]) {
            return range[0] - heat;
        }
        if (heat > range[1]) {
            return range[1] - heat;
        }
        return 0;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

