/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easygiantsfoundry;

import com.google.inject.Provides;
import com.toofifty.easygiantsfoundry.BonusWidget;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryConfig;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryHelper;
import com.toofifty.easygiantsfoundry.EasyGiantsFoundryState;
import com.toofifty.easygiantsfoundry.FoundryOverlay2D;
import com.toofifty.easygiantsfoundry.FoundryOverlay3D;
import com.toofifty.easygiantsfoundry.MouldHelper;
import com.toofifty.easygiantsfoundry.enums.Stage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Skill;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Easy Giant's Foundry", description="Helpful overlays for the Giant's Foundry minigame")
public class EasyGiantsFoundryPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EasyGiantsFoundryPlugin.class);
    private static final int TRIP_HAMMER = 44619;
    private static final int GRINDSTONE = 44620;
    private static final int POLISHING_WHEEL = 44621;
    private static final int LAVA_POOL = 44631;
    private static final int WATERFALL = 44632;
    private static final int CRUCIBLE = 44776;
    private static final int MOULD_JIG = 44777;
    private static final int KOVAC_NPC = 11472;
    private static final int PREFORM = 27010;
    private static final int REPUTATION_VARBIT = 3436;
    private Stage oldStage;
    private int lastBoost;
    private boolean bonusNotified = false;
    private int reputation;
    @Inject
    private EasyGiantsFoundryState state;
    @Inject
    private EasyGiantsFoundryHelper helper;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private FoundryOverlay2D overlay2d;
    @Inject
    private FoundryOverlay3D overlay3d;
    @Inject
    private MouldHelper mouldHelper;
    @Inject
    private EasyGiantsFoundryConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay2d);
        this.overlayManager.add((Overlay)this.overlay3d);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.reputation = this.client.getVarpValue(3436);
        }
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay2d);
        this.overlayManager.remove((Overlay)this.overlay3d);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 44621: {
                this.state.setEnabled(true);
                this.overlay3d.polishingWheel = gameObject;
                break;
            }
            case 44620: {
                this.overlay3d.grindstone = gameObject;
                break;
            }
            case 44631: {
                this.overlay3d.lavaPool = gameObject;
                break;
            }
            case 44632: {
                this.overlay3d.waterfall = gameObject;
                break;
            }
            case 44619: {
                this.overlay3d.tripHammer = gameObject;
                break;
            }
            case 44777: {
                this.overlay3d.mouldJig = gameObject;
                break;
            }
            case 44776: {
                this.overlay3d.crucible = gameObject;
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().equals((Object)GameState.LOADING)) {
            this.state.setEnabled(false);
        }
        if (event.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.reputation = this.client.getVarpValue(3436);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        int curBoost = statChanged.getBoostedLevel();
        if (!statChanged.getSkill().equals((Object)Skill.SMITHING) || curBoost != this.lastBoost || !this.state.isEnabled() || this.state.getCurrentStage() == null) {
            this.lastBoost = curBoost;
            return;
        }
        if (this.config.showGiantsFoundryStageNotifications() && this.helper.getActionsLeftInStage() == this.config.StageNotificationsThreshold() && (this.oldStage == null || this.oldStage != this.state.getCurrentStage())) {
            this.notifier.notify("About to finish the current stage!");
            this.oldStage = this.state.getCurrentStage();
        } else if (this.config.showGiantsFoundryHeatNotifications() && this.helper.getActionsForHeatLevel() == this.config.HeatNotificationsThreshold()) {
            this.notifier.notify("About to run out of heat!");
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 44621: {
                this.state.setEnabled(false);
                this.overlay3d.polishingWheel = null;
                break;
            }
            case 44620: {
                this.overlay3d.grindstone = null;
                break;
            }
            case 44631: {
                this.overlay3d.lavaPool = null;
                break;
            }
            case 44632: {
                this.overlay3d.waterfall = null;
                break;
            }
            case 44619: {
                this.overlay3d.tripHammer = null;
                break;
            }
            case 44777: {
                this.overlay3d.mouldJig = null;
                break;
            }
            case 44776: {
                this.overlay3d.crucible = null;
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getId() == 11472) {
            this.overlay3d.kovac = event.getNpc();
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getId() == 11472) {
            this.overlay3d.kovac = null;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.EQUIPMENT.getId() && event.getItemContainer().count(27010) == 0) {
            this.state.reset();
            this.oldStage = null;
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 6093 || event.getScriptId() == 6095 || event.getScriptId() == 6098 || event.getScriptId() == 6108) {
            this.mouldHelper.selectBest(event.getScriptId());
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarpId() == 3436) {
            this.reputation = this.client.getVarpValue(3436);
        }
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged configChanged) {
        if (!"easygiantsfoundry".equals(configChanged.getGroup())) {
            return;
        }
        if ("soundID".equals(configChanged.getKey())) {
            this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.soundId()));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.checkBonus();
    }

    private void checkBonus() {
        if (!this.state.isEnabled() || this.state.getCurrentStage() == null || this.state.getCurrentStage().getHeat() != this.state.getCurrentHeat() || !BonusWidget.isActive(this.client)) {
            this.bonusNotified = false;
            return;
        }
        if (this.bonusNotified) {
            return;
        }
        if (this.config.bonusNotification()) {
            this.notifier.notify("Bonus - Click tool");
        }
        if (this.config.bonusSoundNotify()) {
            this.client.playSoundEffect(this.config.soundId());
        }
        this.bonusNotified = true;
    }

    @Provides
    EasyGiantsFoundryConfig provideConfig(ConfigManager configManager) {
        return (EasyGiantsFoundryConfig)configManager.getConfig(EasyGiantsFoundryConfig.class);
    }

    public int getReputation() {
        return this.reputation;
    }
}

