/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easygiantsfoundry;

import com.toofifty.easygiantsfoundry.EasyGiantsFoundryState;
import com.toofifty.easygiantsfoundry.enums.Heat;
import com.toofifty.easygiantsfoundry.enums.Stage;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EasyGiantsFoundryHelper {
    private static final int HEAT_LAVA_HEAT = 8;
    private static final int COOL_WATERFALL_HEAT = -8;
    private static final int DUNK_LAVA_HEAT = 32;
    private static final int QUENCH_WATERFALL_HEAT = -32;
    @Inject
    private EasyGiantsFoundryState state;

    public double getProgressPerStage() {
        return 1000.0 / (double)this.state.getStages().size();
    }

    public int getActionsLeftInStage() {
        int progress = this.state.getProgressAmount();
        double progressPerStage = this.getProgressPerStage();
        double progressTillNext = progressPerStage - (double)progress % progressPerStage;
        Stage current = this.state.getCurrentStage();
        return (int)Math.ceil(progressTillNext / (double)current.getProgressPerAction());
    }

    public int[] getCurrentHeatRange() {
        switch (this.state.getCurrentStage()) {
            case POLISHING_WHEEL: {
                return this.state.getLowHeatRange();
            }
            case GRINDSTONE: {
                return this.state.getMedHeatRange();
            }
            case TRIP_HAMMER: {
                return this.state.getHighHeatRange();
            }
        }
        return new int[]{0, 0};
    }

    public int getActionsForHeatLevel() {
        Stage stage;
        Heat heatStage = this.state.getCurrentHeat();
        if (heatStage != (stage = this.state.getCurrentStage()).getHeat()) {
            return 0;
        }
        int[] range = this.getCurrentHeatRange();
        int actions = 0;
        for (int heat = this.state.getHeatAmount(); heat > range[0] && heat < range[1]; heat += stage.getHeatChange()) {
            ++actions;
        }
        return actions;
    }
}

