/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.taskchecker.var;

import java.util.function.BiFunction;
import net.runelite.api.Client;

public class Var {
    private boolean isVarbit;
    private int varIndex;
    private int targetValue;
    private BiFunction<Integer, Integer, Boolean> targetFunction;
    private int currentValue;

    public Var(boolean isVarbit, int varIndex, int targetValue, BiFunction<Integer, Integer, Boolean> targetFunction) {
        this.isVarbit = isVarbit;
        this.varIndex = varIndex;
        this.targetValue = targetValue;
        this.targetFunction = targetFunction;
    }

    public int setCurrentValue(Client client) {
        this.currentValue = this.isVarbit ? client.getVarbitValue(this.varIndex) : client.getVarpValue(this.varIndex);
        return this.currentValue;
    }

    public boolean isComplete() {
        return this.targetFunction.apply(this.currentValue, this.targetValue);
    }

    public String toString() {
        String varType = this.isVarbit ? "Varbit" : "Varplayer";
        return varType + " " + this.varIndex;
    }

    public static boolean isEqualTargetValue(int currentValue, int targetValue) {
        return currentValue == targetValue;
    }

    public static boolean isAtLeastTargetValue(int currentValue, int targetValue) {
        return currentValue >= targetValue;
    }

    public static boolean hasBitFlipped(int currentValue, int bitPosition) {
        return (currentValue & 1 << bitPosition) != 0;
    }

    public int getTargetValue() {
        return this.targetValue;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }
}

