/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.taskchecker;

import com.andmcadams.taskchecker.Task;
import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;

public class TaskPanel
extends JPanel {
    private static final Color INCOMPLETE = Color.RED;
    private static final Color COMPLETE = Color.GREEN;
    private JTextArea nameLabel;
    private Task task;

    public TaskPanel(Task task) {
        this.task = task;
        this.setLayout((LayoutManager)new DynamicGridLayout(1, 1, 0, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameLabel = new JTextArea();
        this.nameLabel.setWrapStyleWord(true);
        this.nameLabel.setLineWrap(true);
        this.nameLabel.setEditable(false);
        this.nameLabel.setOpaque(false);
        this.nameLabel.setFocusable(false);
        this.nameLabel.setText(task.getName());
        this.nameLabel.setForeground(INCOMPLETE);
        this.add(this.nameLabel);
    }

    public boolean updateCompletion() {
        boolean isComplete = this.task.isComplete();
        Color c = isComplete ? COMPLETE : INCOMPLETE;
        this.nameLabel.setForeground(c);
        return isComplete;
    }

    public Task getTask() {
        return this.task;
    }
}

