/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.taskchecker;

import com.andmcadams.taskchecker.CompleteTaskList;
import com.andmcadams.taskchecker.Task;
import com.andmcadams.taskchecker.TaskCheckerPanel;
import com.andmcadams.taskchecker.tasklist.TaskList;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Task Checker")
public class TaskCheckerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TaskCheckerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    private CompleteTaskList tasks;
    private TaskCheckerPanel taskCheckerPanel;
    private NavigationButton navButton;
    private ArrayList<TaskList> tasksCopy;

    protected void startUp() throws Exception {
        log.info("Task Checker started!");
        this.tasks = new CompleteTaskList();
        this.tasksCopy = this.tasks.getTaskLists();
        this.taskCheckerPanel = new TaskCheckerPanel(this, this.tasksCopy);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/task_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Task Checker").icon(icon).priority(7).panel((PluginPanel)this.taskCheckerPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        log.info("Task Checker stopped!");
        this.clientToolbar.removeNavigation(this.navButton);
    }

    public void checkTasks() {
        this.clientThread.invoke(() -> {
            for (TaskList taskList : this.tasksCopy) {
                for (Task task : taskList.getTasks()) {
                    task.setCurrentValues(this.client);
                }
            }
            SwingUtilities.invokeLater(() -> this.taskCheckerPanel.refresh());
        });
    }
}

