/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.taskchecker;

import com.andmcadams.taskchecker.FixedWidthPanel;
import com.andmcadams.taskchecker.Task;
import com.andmcadams.taskchecker.TaskCheckerPlugin;
import com.andmcadams.taskchecker.TaskListHeaderPanel;
import com.andmcadams.taskchecker.TaskPanel;
import com.andmcadams.taskchecker.tasklist.TaskList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCheckerPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(TaskCheckerPanel.class);
    TaskCheckerPlugin taskCheckerPlugin;
    ArrayList<TaskPanel> taskPanelList = new ArrayList();
    private JScrollPane scrollPane;

    public TaskCheckerPanel(TaskCheckerPlugin taskCheckerPlugin, ArrayList<TaskList> taskLists) {
        super(false);
        this.taskCheckerPlugin = taskCheckerPlugin;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel topContainer = new JPanel();
        topContainer.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        titlePanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setText("Task Checker");
        title.setForeground(Color.WHITE);
        titlePanel.add((Component)title, "West");
        topContainer.add((Component)titlePanel, "North");
        JButton calculateTasksButton = new JButton("Check tasks");
        calculateTasksButton.setBorder(new EmptyBorder(10, 10, 10, 10));
        calculateTasksButton.setLayout(new BorderLayout());
        calculateTasksButton.addActionListener(event -> this.checkTasks());
        topContainer.add((Component)calculateTasksButton, "South");
        this.add(topContainer, "North");
        FixedWidthPanel taskListPanel = new FixedWidthPanel();
        taskListPanel.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 2));
        for (TaskList taskList : taskLists) {
            this.addTaskListHeader(taskListPanel, taskList.getName());
            for (Task task : taskList.getTasks()) {
                this.addTask(taskListPanel, task);
            }
        }
        this.scrollPane = new JScrollPane(taskListPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.scrollPane.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.add(this.scrollPane, "Center");
    }

    public void addTaskListHeader(JPanel taskListPanel, String name) {
        TaskListHeaderPanel taskListHeaderPanel = new TaskListHeaderPanel(name);
        taskListPanel.add(taskListHeaderPanel);
    }

    public void addTask(JPanel taskListPanel, Task task) {
        TaskPanel taskPanel = new TaskPanel(task);
        this.taskPanelList.add(taskPanel);
        taskListPanel.add(taskPanel);
    }

    public void checkTasks() {
        this.taskCheckerPlugin.checkTasks();
    }

    public void refresh() {
        for (TaskPanel taskPanel : this.taskPanelList) {
            taskPanel.updateCompletion();
        }
        this.repaint();
        this.revalidate();
    }
}

