/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.taskchecker;

import com.andmcadams.taskchecker.var.Var;
import java.util.ArrayList;
import net.runelite.api.Client;

public class Task {
    private String name;
    private ArrayList<Var> varsToCheck;

    public Task(String name, ArrayList<Var> varsToCheck) {
        this.name = name;
        this.varsToCheck = varsToCheck;
    }

    public void setCurrentValues(Client client) {
        for (Var v : this.varsToCheck) {
            v.setCurrentValue(client);
        }
    }

    public boolean isComplete() {
        for (Var v : this.varsToCheck) {
            if (v.isComplete()) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Var> getVarsToCheck() {
        return (ArrayList)this.varsToCheck.clone();
    }

    public String getName() {
        return this.name;
    }

    public static class TaskBuilder {
        private String name;
        private ArrayList<Var> varsToCheck = new ArrayList();

        public TaskBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TaskBuilder switchVar(boolean isVarbit, int varIndex) {
            Var v = new Var(isVarbit, varIndex, 1, Var::isEqualTargetValue);
            this.varsToCheck.add(v);
            return this;
        }

        public TaskBuilder eqVar(boolean isVarbit, int varIndex, int targetValue) {
            Var v = new Var(isVarbit, varIndex, targetValue, Var::isEqualTargetValue);
            this.varsToCheck.add(v);
            return this;
        }

        public TaskBuilder geVar(boolean isVarbit, int varIndex, int targetValue) {
            Var v = new Var(isVarbit, varIndex, targetValue, Var::isAtLeastTargetValue);
            this.varsToCheck.add(v);
            return this;
        }

        public TaskBuilder bitVar(boolean isVarbit, int varIndex, int bitPosition) {
            Var v = new Var(isVarbit, varIndex, bitPosition, Var::hasBitFlipped);
            this.varsToCheck.add(v);
            return this;
        }

        public Task build() {
            Task task = new Task(this.name, this.varsToCheck);
            return task;
        }
    }
}

