/*
 * Decompiled with CFR 0.152.
 */
package trevor.raidpointsoverlay;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import trevor.raidpointsoverlay.RaidPointsOverlayPlugin;
import trevor.raidpointsoverlay.RaidsPointsConfig;
import trevor.raidpointsoverlay.UniqueConfigOptions;

public class RaidsPointsOverlay
extends OverlayPanel {
    private static final DecimalFormat POINTS_FORMAT = new DecimalFormat("#,###");
    private static final DecimalFormat POINTS_PERCENT_FORMAT = new DecimalFormat(" (##0.00%)");
    private static final DecimalFormat UNIQUE_FORMAT = new DecimalFormat("#0.00%");
    private Client client;
    private RaidPointsOverlayPlugin plugin;
    private RaidsPointsConfig config;
    private TooltipManager tooltipManager;

    @Inject
    private RaidsPointsOverlay(Client client, RaidPointsOverlayPlugin plugin, RaidsPointsConfig config, TooltipManager tooltipManager) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.tooltipManager = tooltipManager;
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        String tooltip;
        Point mousePosition;
        Rectangle bounds;
        if (!this.plugin.isInRaidChambers()) {
            return null;
        }
        int totalPoints = this.client.getVar(5431);
        int personalPoints = this.client.getVar(5422);
        int partySize = this.client.getVar(5424);
        FontMetrics metrics = graphics.getFontMetrics();
        this.panelComponent.getChildren().add(LineComponent.builder().left("Total:").right(POINTS_FORMAT.format(totalPoints)).build());
        Object personalPointsPercent = "";
        if (this.config.raidsPointsPercent() && partySize > 1) {
            personalPointsPercent = (String)personalPointsPercent + (totalPoints > 0 ? POINTS_PERCENT_FORMAT.format((double)personalPoints / (double)totalPoints) : POINTS_PERCENT_FORMAT.format(0L));
        }
        String personalPointsString = POINTS_FORMAT.format(personalPoints) + (String)personalPointsPercent;
        this.panelComponent.getChildren().add(LineComponent.builder().left(this.client.getLocalPlayer().getName() + ":").right(personalPointsString).build());
        if (this.config.raidsTimer()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Time:").right(this.plugin.getTime()).build());
        }
        if (partySize > 1 && this.config.showTeamSize()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Party size:").right(String.valueOf(partySize)).build());
        }
        if (this.config.raidsUniqueChance() != UniqueConfigOptions.OFF) {
            Object uniqueChance;
            double personalUniqueChance = Math.min((double)personalPoints / 867500.0, 0.657);
            String personalUniqueChanceStr = UNIQUE_FORMAT.format(personalUniqueChance);
            double totalUniqueChance = Math.min((double)totalPoints / 867500.0, 0.657);
            String totalUniqueChanceStr = UNIQUE_FORMAT.format(totalUniqueChance);
            if (this.config.raidsUniqueChance() == UniqueConfigOptions.BOTH) {
                uniqueChance = personalUniqueChanceStr;
                if (partySize > 1) {
                    uniqueChance = (String)uniqueChance + " (" + totalUniqueChanceStr + ")";
                }
            } else {
                uniqueChance = this.config.raidsUniqueChance() == UniqueConfigOptions.PERSONAL_CHANCE ? personalUniqueChanceStr : totalUniqueChanceStr;
            }
            this.panelComponent.getChildren().add(LineComponent.builder().left("Unique:").right((String)uniqueChance).build());
        }
        if ((bounds = this.getBounds()).getX() > 0.0 && bounds.contains((mousePosition = this.client.getMouseCanvasPosition()).getX(), mousePosition.getY()) && (tooltip = this.plugin.getTooltip()) != null) {
            this.tooltipManager.add(new Tooltip(tooltip));
        }
        return super.render(graphics);
    }
}

