/*
 * Decompiled with CFR 0.152.
 */
package trevor.raidpointsoverlay;

import com.google.inject.Provides;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import trevor.raidpointsoverlay.RaidsPointsConfig;
import trevor.raidpointsoverlay.RaidsPointsOverlay;

@PluginDescriptor(name="Raid Points Overlay")
public class RaidPointsOverlayPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RaidPointsOverlayPlugin.class);
    private static final Pattern LEVEL_COMPLETE_REGEX = Pattern.compile("(.+) level complete! Duration: ([0-9:]+)");
    private static final Pattern RAID_COMPLETE_REGEX = Pattern.compile("Congratulations - your raid is complete! Duration: ([0-9:]+)");
    private static final int RAID_TIMER_VARBIT = 6386;
    private static final int RAID_STATE_VARBIT = 5425;
    private static final int RAID_BANK_REGION = 4919;
    private static final int RAID_POINT_WIDGET_SCRIPT = 1510;
    @Inject
    private Client client;
    @Inject
    private RaidsPointsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    private boolean inRaidChambers;
    private int raidState;
    private int timerVarb;
    private int upperTime = -1;
    private int middleTime = -1;
    private int lowerTime = -1;
    private int raidTime = -1;
    private String tooltip;

    @Provides
    RaidsPointsConfig provideConfig(ConfigManager configManager) {
        return (RaidsPointsConfig)configManager.getConfig(RaidsPointsConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invoke(() -> this.setHidden(true));
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientThread.invoke(() -> this.setHidden(false));
        this.reset();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.inRaidChambers = this.client.getVar(5432) == 1;
        this.raidState = this.client.getVarbitValue(5425);
        this.timerVarb = this.client.getVarbitValue(6386);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 1510 || !this.inRaidChambers) {
            return;
        }
        Widget widget = this.client.getWidget(WidgetInfo.RAIDS_POINTS_INFOBOX);
        if (widget == null || widget.isHidden()) {
            return;
        }
        widget.setHidden(true);
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.timerVarb > 0 && this.raidState < 5) {
            this.client.runScript(new Object[]{2289, 0, 0, 0});
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.inRaidChambers && event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION) {
            String message = Text.removeTags((String)event.getMessage());
            Matcher matcher = LEVEL_COMPLETE_REGEX.matcher(message);
            if (matcher.find()) {
                String floor = matcher.group(1);
                int time = this.timeToSeconds(matcher.group(2));
                if (floor.equals("Upper")) {
                    this.upperTime = time;
                } else if (floor.equals("Middle")) {
                    this.middleTime = time;
                } else if (floor.equals("Lower")) {
                    this.lowerTime = time;
                }
                this.updateTooltip();
            }
            if ((matcher = RAID_COMPLETE_REGEX.matcher(message)).find()) {
                this.raidTime = this.timeToSeconds(matcher.group(1));
                this.updateTooltip();
            }
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getWorldLocation().getRegionID() == 4919) {
            this.reset();
        }
    }

    private void setHidden(boolean shouldHide) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        boolean bl = this.inRaidChambers = this.client.getVar(5432) == 1;
        if (!this.inRaidChambers) {
            return;
        }
        Widget widget = this.client.getWidget(WidgetInfo.RAIDS_POINTS_INFOBOX);
        if (widget != null) {
            widget.setHidden(shouldHide);
        }
    }

    public void reset() {
        this.upperTime = -1;
        this.middleTime = -1;
        this.lowerTime = -1;
        this.raidTime = -1;
        this.tooltip = null;
    }

    private int timeToSeconds(String s) {
        int seconds = -1;
        String[] split = s.split(":");
        if (split.length == 2) {
            seconds = Integer.parseInt(split[0]) * 60 + Integer.parseInt(split[1]);
        }
        if (split.length == 3) {
            seconds = Integer.parseInt(split[0]) * 3600 + Integer.parseInt(split[1]) * 60 + Integer.parseInt(split[2]);
        }
        return seconds;
    }

    private String secondsToTime(int seconds) {
        StringBuilder builder = new StringBuilder();
        if (seconds >= 3600) {
            builder.append((int)Math.floor(seconds / 3600) + ":");
        }
        seconds %= 3600;
        if (builder.toString().equals("")) {
            builder.append((int)Math.floor(seconds / 60));
        } else {
            builder.append(StringUtils.leftPad((String)String.valueOf((int)Math.floor(seconds / 60)), (int)2, (char)'0'));
        }
        builder.append(":");
        builder.append(StringUtils.leftPad((String)String.valueOf(seconds %= 60), (int)2, (char)'0'));
        return builder.toString();
    }

    private void updateTooltip() {
        StringBuilder builder = new StringBuilder();
        if (this.upperTime == -1) {
            this.tooltip = null;
            return;
        }
        builder.append("Upper level: " + this.secondsToTime(this.upperTime));
        if (this.middleTime == -1) {
            if (this.lowerTime == -1) {
                this.tooltip = builder.toString();
                return;
            }
            builder.append("</br>Lower level: " + this.secondsToTime(this.lowerTime - this.upperTime));
        } else {
            builder.append("</br>Middle level: " + this.secondsToTime(this.middleTime - this.upperTime));
            if (this.lowerTime == -1) {
                this.tooltip = builder.toString();
                return;
            }
            builder.append("</br>Lower level: " + this.secondsToTime(this.lowerTime - this.middleTime));
        }
        if (this.raidTime == -1) {
            this.tooltip = builder.toString();
            return;
        }
        builder.append("</br>Olm: " + this.secondsToTime(this.raidTime - this.lowerTime));
        this.tooltip = builder.toString();
    }

    String getTime() {
        int seconds = (int)Math.floor((double)this.client.getVarbitValue(6386) * 0.6);
        return this.secondsToTime(seconds);
    }

    public boolean isInRaidChambers() {
        return this.inRaidChambers;
    }

    public String getTooltip() {
        return this.tooltip;
    }
}

