/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.maze;

import ca.gauntlet.module.maze.Resource;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.util.ImageUtil;

class ResourceGameObject {
    private static final int DEFAULT_ICON_SIZE = 14;
    private final Resource resource;
    private final GameObject gameObject;
    private final BufferedImage originalIcon;
    private final BufferedImage minimapIcon;
    private BufferedImage icon;
    private int iconSize;

    ResourceGameObject(@NonNull GameObject gameObject, @NonNull SkillIconManager skillIconManager, int iconSize) {
        if (gameObject == null) {
            throw new NullPointerException("gameObject is marked non-null but is null");
        }
        if (skillIconManager == null) {
            throw new NullPointerException("skillIconManager is marked non-null but is null");
        }
        this.gameObject = gameObject;
        this.iconSize = iconSize;
        this.resource = ResourceGameObject.getResourceByObjectId(gameObject.getId());
        this.originalIcon = ResourceGameObject.getOriginalIcon(this.resource, skillIconManager, false);
        this.minimapIcon = ResourceGameObject.getOriginalIcon(this.resource, skillIconManager, true);
    }

    void setIconSize(int iconSize) {
        this.iconSize = iconSize;
        int size = iconSize <= 0 ? 14 : iconSize;
        this.icon = ImageUtil.resizeImage((BufferedImage)this.originalIcon, (int)size, (int)size);
    }

    BufferedImage getIcon() {
        if (this.icon == null) {
            int size = this.iconSize <= 0 ? 14 : this.iconSize;
            this.icon = ImageUtil.resizeImage((BufferedImage)this.originalIcon, (int)size, (int)size);
        }
        return this.icon;
    }

    @Nullable
    Point getMinimapPoint() {
        Point point = this.gameObject.getMinimapLocation();
        if (point == null) {
            return null;
        }
        return new Point(point.getX() - this.minimapIcon.getHeight() / 2, point.getY() - this.minimapIcon.getWidth() / 2);
    }

    private static BufferedImage getOriginalIcon(Resource resource, SkillIconManager skillIconManager, boolean small) {
        switch (resource) {
            case RAW_PADDLEFISH: {
                return skillIconManager.getSkillImage(Skill.FISHING, small);
            }
            case CRYSTAL_ORE: 
            case CORRUPTED_ORE: {
                return skillIconManager.getSkillImage(Skill.MINING, small);
            }
            case PHREN_BARK: 
            case CORRUPTED_PHREN_BARK: {
                return skillIconManager.getSkillImage(Skill.WOODCUTTING, small);
            }
            case LINUM_TIRINUM: 
            case CORRUPTED_LINUM_TIRINUM: {
                return skillIconManager.getSkillImage(Skill.FARMING, small);
            }
            case GRYM_LEAF: 
            case CORRUPTED_GRYM_LEAF: {
                return skillIconManager.getSkillImage(Skill.HERBLORE, small);
            }
        }
        throw new IllegalArgumentException("Unsupported resource: " + resource);
    }

    private static Resource getResourceByObjectId(int objectId) {
        switch (objectId) {
            case 36064: {
                return Resource.CRYSTAL_ORE;
            }
            case 35967: {
                return Resource.CORRUPTED_ORE;
            }
            case 36066: {
                return Resource.PHREN_BARK;
            }
            case 35969: {
                return Resource.CORRUPTED_PHREN_BARK;
            }
            case 36072: {
                return Resource.LINUM_TIRINUM;
            }
            case 35975: {
                return Resource.CORRUPTED_LINUM_TIRINUM;
            }
            case 36070: {
                return Resource.GRYM_LEAF;
            }
            case 35973: {
                return Resource.CORRUPTED_GRYM_LEAF;
            }
            case 35971: 
            case 36068: {
                return Resource.RAW_PADDLEFISH;
            }
        }
        throw new IllegalArgumentException("Unsupported game object id: " + objectId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceGameObject)) {
            return false;
        }
        ResourceGameObject that = (ResourceGameObject)o;
        return this.gameObject.equals(that.gameObject);
    }

    public int hashCode() {
        return this.gameObject.hashCode();
    }

    public String toString() {
        return "SkillResource{resource=" + this.resource + ", gameObject=" + this.gameObject + "}";
    }

    Resource getResource() {
        return this.resource;
    }

    GameObject getGameObject() {
        return this.gameObject;
    }

    BufferedImage getMinimapIcon() {
        return this.minimapIcon;
    }
}

