/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.maze;

import ca.gauntlet.TheGauntletConfig;
import ca.gauntlet.TheGauntletPlugin;
import ca.gauntlet.module.maze.Demiboss;
import ca.gauntlet.module.maze.MazeModule;
import ca.gauntlet.module.maze.ResourceGameObject;
import ca.gauntlet.module.maze.ResourceManager;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
class MinimapOverlay
extends Overlay {
    private final TheGauntletConfig config;
    private final MazeModule mazeModule;
    private final ResourceManager resourceManager;

    @Inject
    MinimapOverlay(TheGauntletPlugin plugin, TheGauntletConfig config, MazeModule mazeModule, ResourceManager resourceManager) {
        super((Plugin)plugin);
        this.config = config;
        this.mazeModule = mazeModule;
        this.resourceManager = resourceManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics2D) {
        if (this.config.minimapResourceOverlay()) {
            this.renderMinimapResourceIcons(graphics2D, this.mazeModule.getResourceGameObjects());
        }
        if (this.config.minimapDemibossOverlay()) {
            this.renderMinimapNPCIcons(graphics2D, this.mazeModule.getDemiBosses());
        }
        return null;
    }

    private void renderMinimapNPCIcons(Graphics2D graphics2D, Collection<Demiboss> demiBosses) {
        if (demiBosses.isEmpty()) {
            return;
        }
        for (Demiboss demiboss : demiBosses) {
            Point point = demiboss.getMinimapPoint();
            if (point == null) continue;
            OverlayUtil.renderImageLocation((Graphics2D)graphics2D, (Point)point, (BufferedImage)demiboss.getMinimapIcon());
        }
    }

    private void renderMinimapResourceIcons(Graphics2D graphics2D, Collection<ResourceGameObject> resourceGameObjects) {
        if (resourceGameObjects.isEmpty()) {
            return;
        }
        for (ResourceGameObject resourceGameObject : resourceGameObjects) {
            Point point;
            if (this.config.resourceTracker() && this.config.resourceRemoveOutlineOnceAcquired() && this.resourceManager.hasAcquired(resourceGameObject.getResource()) || (point = resourceGameObject.getMinimapPoint()) == null) continue;
            OverlayUtil.renderImageLocation((Graphics2D)graphics2D, (Point)point, (BufferedImage)resourceGameObject.getMinimapIcon());
        }
    }
}

