/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.maze;

import ca.gauntlet.TheGauntletConfig;
import ca.gauntlet.TheGauntletPlugin;
import ca.gauntlet.module.maze.MazeModule;
import ca.gauntlet.module.maze.Resource;
import ca.gauntlet.module.maze.ResourceGameObject;
import ca.gauntlet.module.maze.ResourceManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Perspective;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

@Singleton
class MazeOverlay
extends Overlay {
    private final Client client;
    private final TheGauntletConfig config;
    private final MazeModule mazeModule;
    private final ModelOutlineRenderer modelOutlineRenderer;
    private final ResourceManager resourceManager;

    @Inject
    MazeOverlay(Client client, TheGauntletPlugin plugin, TheGauntletConfig config, MazeModule mazeModule, ModelOutlineRenderer modelOutlineRenderer, ResourceManager resourceManager) {
        super((Plugin)plugin);
        this.client = client;
        this.config = config;
        this.mazeModule = mazeModule;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.resourceManager = resourceManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public Dimension render(Graphics2D graphics2D) {
        this.renderResources(graphics2D);
        this.renderUtilities();
        return null;
    }

    private void renderResources(Graphics2D graphics2D) {
        if (!this.config.overlayResources() || this.mazeModule.getResourceGameObjects().isEmpty()) {
            return;
        }
        for (ResourceGameObject resourceGameObject : this.mazeModule.getResourceGameObjects()) {
            Polygon polygon;
            if (!this.isOverlayEnabled(resourceGameObject.getResource()) || this.config.resourceTracker() && this.config.resourceRemoveOutlineOnceAcquired() && this.resourceManager.hasAcquired(resourceGameObject.getResource())) continue;
            GameObject gameObject = resourceGameObject.getGameObject();
            LocalPoint lp = gameObject.getLocalLocation();
            if (this.config.resourceHullOutlineWidth() > 0) {
                this.modelOutlineRenderer.drawOutline((TileObject)gameObject, this.config.resourceHullOutlineWidth(), this.getResourceOutlineColor(resourceGameObject.getResource()), 1);
            }
            if (this.config.resourceTileOutlineWidth() > 0 && (polygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp)) != null) {
                OverlayUtil.renderPolygon((Graphics2D)graphics2D, (Shape)polygon, (Color)this.getResourceOutlineColor(resourceGameObject.getResource()), (Color)this.getResourceFillColor(resourceGameObject.getResource()), (Stroke)new BasicStroke(this.config.resourceTileOutlineWidth()));
            }
            if (this.config.resourceIconSize() <= 0) continue;
            OverlayUtil.renderImageLocation((Client)this.client, (Graphics2D)graphics2D, (LocalPoint)lp, (BufferedImage)resourceGameObject.getIcon(), (int)0);
        }
    }

    private void renderUtilities() {
        if (!this.config.utilitiesOutline() || this.mazeModule.getUtilities().isEmpty()) {
            return;
        }
        for (GameObject gameObject : this.mazeModule.getUtilities()) {
            this.modelOutlineRenderer.drawOutline((TileObject)gameObject, this.config.utilitiesOutlineWidth(), this.config.utilitiesOutlineColor(), 1);
        }
    }

    private Color getResourceOutlineColor(Resource resource) {
        switch (resource) {
            case RAW_PADDLEFISH: {
                return this.config.fishingSpotOutlineColor();
            }
            case CRYSTAL_ORE: 
            case CORRUPTED_ORE: {
                return this.config.oreDepositOutlineColor();
            }
            case PHREN_BARK: 
            case CORRUPTED_PHREN_BARK: {
                return this.config.phrenRootsOutlineColor();
            }
            case LINUM_TIRINUM: 
            case CORRUPTED_LINUM_TIRINUM: {
                return this.config.linumTirinumOutlineColor();
            }
            case GRYM_LEAF: 
            case CORRUPTED_GRYM_LEAF: {
                return this.config.grymRootOutlineColor();
            }
        }
        throw new IllegalArgumentException("Unsupported resource: " + resource);
    }

    private Color getResourceFillColor(Resource resource) {
        switch (resource) {
            case RAW_PADDLEFISH: {
                return this.config.fishingSpotFillColor();
            }
            case CRYSTAL_ORE: 
            case CORRUPTED_ORE: {
                return this.config.oreDepositFillColor();
            }
            case PHREN_BARK: 
            case CORRUPTED_PHREN_BARK: {
                return this.config.phrenRootsFillColor();
            }
            case LINUM_TIRINUM: 
            case CORRUPTED_LINUM_TIRINUM: {
                return this.config.linumTirinumFillColor();
            }
            case GRYM_LEAF: 
            case CORRUPTED_GRYM_LEAF: {
                return this.config.grymRootFillColor();
            }
        }
        throw new IllegalArgumentException("Unsupported resource: " + resource);
    }

    private boolean isOverlayEnabled(Resource resource) {
        switch (resource) {
            case RAW_PADDLEFISH: {
                return this.config.overlayFishingSpot();
            }
            case CRYSTAL_ORE: 
            case CORRUPTED_ORE: {
                return this.config.overlayOreDeposit();
            }
            case PHREN_BARK: 
            case CORRUPTED_PHREN_BARK: {
                return this.config.overlayPhrenRoots();
            }
            case LINUM_TIRINUM: 
            case CORRUPTED_LINUM_TIRINUM: {
                return this.config.overlayLinumTirinum();
            }
            case GRYM_LEAF: 
            case CORRUPTED_GRYM_LEAF: {
                return this.config.overlayGrymRoot();
            }
        }
        throw new IllegalArgumentException("Unsupported resource: " + resource);
    }
}

