/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.maze;

import ca.gauntlet.TheGauntletConfig;
import ca.gauntlet.module.Module;
import ca.gauntlet.module.maze.Demiboss;
import ca.gauntlet.module.maze.MazeOverlay;
import ca.gauntlet.module.maze.MinimapOverlay;
import ca.gauntlet.module.maze.ResourceGameObject;
import ca.gauntlet.module.maze.ResourceManager;
import ca.gauntlet.module.overlay.TimerOverlay;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.PostMenuSort;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@Singleton
public final class MazeModule
implements Module {
    private static final List<Integer> NPC_IDS_DEMIBOSS = List.of(Integer.valueOf(9032), Integer.valueOf(9034), Integer.valueOf(9033), Integer.valueOf(9046), Integer.valueOf(9048), Integer.valueOf(9047));
    private static final List<Integer> GAME_OBJECT_IDS_RESOURCE = List.of(Integer.valueOf(36064), Integer.valueOf(36066), Integer.valueOf(36068), Integer.valueOf(36070), Integer.valueOf(36072), Integer.valueOf(35967), Integer.valueOf(35969), Integer.valueOf(35971), Integer.valueOf(35973), Integer.valueOf(35975));
    private static final List<Integer> GAME_OBJECT_IDS_UTILITY = List.of(Integer.valueOf(35966), Integer.valueOf(35980), Integer.valueOf(35981), Integer.valueOf(36063), Integer.valueOf(36077), Integer.valueOf(36078));
    private final Set<ResourceGameObject> resourceGameObjects = new HashSet<ResourceGameObject>();
    private final Set<Demiboss> demiBosses = new HashSet<Demiboss>();
    private final Set<GameObject> utilities = new HashSet<GameObject>();
    private final Function<NPC, HighlightedNpc> npcHighlighter = this::highlightNpc;
    @Inject
    private EventBus eventBus;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TheGauntletConfig config;
    @Inject
    private NpcOverlayService npcOverlayService;
    @Inject
    private ResourceManager resourceManager;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MazeOverlay mazeOverlay;
    @Inject
    private MinimapOverlay minimapOverlay;
    @Inject
    private TimerOverlay timerOverlay;

    @Override
    public void start() {
        this.eventBus.register((Object)this);
        this.npcOverlayService.registerHighlighter(this.npcHighlighter);
        this.overlayManager.add((Overlay)this.mazeOverlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.overlayManager.add((Overlay)this.timerOverlay);
    }

    @Override
    public void stop() {
        this.eventBus.unregister((Object)this);
        this.npcOverlayService.unregisterHighlighter(this.npcHighlighter);
        this.overlayManager.remove((Overlay)this.mazeOverlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.overlayManager.remove((Overlay)this.timerOverlay);
        this.resourceManager.reset();
        this.resourceGameObjects.clear();
        this.utilities.clear();
        this.demiBosses.clear();
    }

    @Subscribe
    void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("thegauntlet")) {
            return;
        }
        this.clientThread.invoke(() -> {
            switch (event.getKey()) {
                case "resourceIconSize": {
                    if (this.resourceGameObjects.isEmpty()) break;
                    this.resourceGameObjects.forEach(r -> r.setIconSize(this.config.resourceIconSize()));
                    break;
                }
                case "resourceTracker": 
                case "resourceTrackingMode": 
                case "resourceRemoveAcquired": {
                    this.resourceManager.reset();
                    this.resourceManager.init(this.client.getMapRegions()[0]);
                    break;
                }
                default: {
                    this.npcOverlayService.rebuild();
                }
            }
        });
    }

    @Subscribe
    void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOADING: {
                this.resourceGameObjects.clear();
                this.utilities.clear();
                break;
            }
            case LOGIN_SCREEN: 
            case HOPPING: {
                this.stop();
            }
        }
    }

    @Subscribe
    public void onPostMenuSort(PostMenuSort postMenuSort) {
        if (!this.config.utilitiesFishCheck() || this.client.isMenuOpen()) {
            return;
        }
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        if (container == null) {
            return;
        }
        boolean hasRawFish = Arrays.stream(container.getItems()).anyMatch(x -> x.getId() == 23872);
        if (!hasRawFish) {
            return;
        }
        MenuEntry[] filteredEntires = (MenuEntry[])Arrays.stream(this.client.getMenuEntries()).filter(x -> !x.getOption().equals("Quick-pass") && !x.getOption().equals("Pass")).toArray(MenuEntry[]::new);
        this.client.setMenuEntries(filteredEntires);
    }

    @Subscribe
    void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 637) {
            this.resourceManager.init(this.client.getMapRegions()[0]);
            this.timerOverlay.setGauntletStart();
        }
    }

    @Subscribe
    void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        int id = gameObject.getId();
        if (GAME_OBJECT_IDS_RESOURCE.contains(id)) {
            this.resourceGameObjects.add(new ResourceGameObject(gameObject, this.skillIconManager, this.config.resourceIconSize()));
        } else if (GAME_OBJECT_IDS_UTILITY.contains(id)) {
            this.utilities.add(gameObject);
        }
    }

    @Subscribe
    void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        int id = gameObject.getId();
        if (GAME_OBJECT_IDS_RESOURCE.contains(id)) {
            this.resourceGameObjects.removeIf(o -> o.getGameObject() == gameObject);
        } else if (GAME_OBJECT_IDS_UTILITY.contains(id)) {
            this.utilities.remove(gameObject);
        }
    }

    @Subscribe
    void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (NPC_IDS_DEMIBOSS.contains(npc.getId())) {
            this.demiBosses.add(new Demiboss(npc, this.skillIconManager));
        }
    }

    @Subscribe
    void onNpcDespawned(NpcDespawned event) {
        NPC npc = event.getNpc();
        if (NPC_IDS_DEMIBOSS.contains(npc.getId())) {
            this.demiBosses.removeIf(d -> d.isNpc(npc));
        }
    }

    @Subscribe
    void onActorDeath(ActorDeath event) {
        if (event.getActor() == this.client.getLocalPlayer()) {
            this.timerOverlay.onPlayerDeath();
        }
    }

    @Subscribe
    void onChatMessage(ChatMessage event) {
        ChatMessageType type = event.getType();
        if (type == ChatMessageType.SPAM || type == ChatMessageType.GAMEMESSAGE) {
            this.resourceManager.parseChatMessage(event.getMessage());
        }
    }

    private HighlightedNpc highlightNpc(NPC npc) {
        Color highlightColor;
        int borderWidth;
        int id = npc.getId();
        switch (id) {
            case 9026: 
            case 9027: 
            case 9028: 
            case 9040: 
            case 9041: 
            case 9042: {
                return HighlightedNpc.builder().npc(npc).outline(true).borderWidth((float)this.config.weakNpcOutlineWidth()).highlightColor(this.config.weakNpcOutlineColor()).render(n -> this.config.weakNpcOutline() && !npc.isDead()).build();
            }
            case 9029: 
            case 9030: 
            case 9031: 
            case 9043: 
            case 9044: 
            case 9045: {
                return HighlightedNpc.builder().npc(npc).outline(true).borderWidth((float)this.config.strongNpcOutlineWidth()).highlightColor(this.config.strongNpcOutlineColor()).render(n -> this.config.strongNpcOutline() && !npc.isDead()).build();
            }
            case 9032: 
            case 9046: {
                borderWidth = this.config.demibossOutlineWidth();
                highlightColor = this.config.bearOutlineColor();
                break;
            }
            case 9034: 
            case 9048: {
                borderWidth = this.config.demibossOutlineWidth();
                highlightColor = this.config.darkBeastOutlineColor();
                break;
            }
            case 9033: 
            case 9047: {
                borderWidth = this.config.demibossOutlineWidth();
                highlightColor = this.config.dragonOutlineColor();
                break;
            }
            default: {
                return null;
            }
        }
        return HighlightedNpc.builder().npc(npc).outline(true).borderWidth((float)borderWidth).highlightColor(highlightColor).render(n -> this.config.demibossOutline() && !npc.isDead()).build();
    }

    Set<ResourceGameObject> getResourceGameObjects() {
        return this.resourceGameObjects;
    }

    Set<Demiboss> getDemiBosses() {
        return this.demiBosses;
    }

    Set<GameObject> getUtilities() {
        return this.utilities;
    }
}

