/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.maze;

import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;

class Demiboss {
    private final NPC npc;
    private final BufferedImage minimapIcon;

    Demiboss(@NonNull NPC npc, @NonNull SkillIconManager skillIconManager) {
        if (npc == null) {
            throw new NullPointerException("npc is marked non-null but is null");
        }
        if (skillIconManager == null) {
            throw new NullPointerException("skillIconManager is marked non-null but is null");
        }
        this.npc = npc;
        this.minimapIcon = Demiboss.getIcon(npc, skillIconManager);
    }

    boolean isNpc(NPC npc) {
        return this.npc == npc;
    }

    @Nullable
    Point getMinimapPoint() {
        Point point = this.npc.getMinimapLocation();
        if (point == null) {
            return null;
        }
        return new Point(point.getX() - this.minimapIcon.getHeight() / 2, point.getY() - this.minimapIcon.getWidth() / 2);
    }

    private static BufferedImage getIcon(NPC npc, SkillIconManager skillIconManager) {
        switch (npc.getId()) {
            case 9032: 
            case 9046: {
                return skillIconManager.getSkillImage(Skill.ATTACK, true);
            }
            case 9034: 
            case 9048: {
                return skillIconManager.getSkillImage(Skill.RANGED, true);
            }
            case 9033: 
            case 9047: {
                return skillIconManager.getSkillImage(Skill.MAGIC, true);
            }
        }
        throw new IllegalArgumentException("Unsupported npc id: " + npc.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Demiboss)) {
            return false;
        }
        Demiboss that = (Demiboss)o;
        return this.npc.equals(that.npc);
    }

    public int hashCode() {
        return this.npc.hashCode();
    }

    public String toString() {
        return "Demiboss{npc=" + this.npc + "}";
    }

    BufferedImage getMinimapIcon() {
        return this.minimapIcon;
    }
}

