/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.boss;

import ca.gauntlet.TheGauntletConfig;
import ca.gauntlet.TheGauntletPlugin;
import ca.gauntlet.module.boss.BossModule;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
class BossOverlay
extends Overlay {
    private final Client client;
    private final TheGauntletConfig config;
    private final BossModule bossModule;

    @Inject
    public BossOverlay(Client client, TheGauntletPlugin plugin, TheGauntletConfig config, BossModule bossModule) {
        super((Plugin)plugin);
        this.client = client;
        this.config = config;
        this.bossModule = bossModule;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public Dimension render(Graphics2D graphics2D) {
        this.renderTornadoes(graphics2D);
        return null;
    }

    private void renderTornadoes(Graphics2D graphics2D) {
        if (this.config.tornadoTileOutline() == TheGauntletConfig.TileOutline.OFF || this.bossModule.getTornadoes().isEmpty()) {
            return;
        }
        boolean trueTile = this.config.tornadoTileOutline() == TheGauntletConfig.TileOutline.TRUE_TILE;
        for (NPC tornado : this.bossModule.getTornadoes()) {
            Polygon polygon;
            if (trueTile) {
                LocalPoint localPoint;
                WorldPoint worldPoint = tornado.getWorldLocation();
                if (worldPoint == null || (localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint)) == null) continue;
                polygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint);
            } else {
                polygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)tornado.getLocalLocation());
            }
            if (polygon == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics2D, (Shape)polygon, (Color)this.config.tornadoOutlineColor(), (Color)this.config.tornadoFillColor(), (Stroke)new BasicStroke(this.config.tornadoTileOutlineWidth()));
        }
    }
}

