/*
 * Decompiled with CFR 0.152.
 */
package com.ailieluibh.autumngarden;

import javax.inject.Singleton;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;

@Singleton
public class ElementalCollisionDetector {
    public static final WorldPoint[] RUNTILES = new WorldPoint[]{new WorldPoint(2908, 5461, 0), new WorldPoint(2904, 5459, 0), new WorldPoint(2901, 5455, 0), new WorldPoint(2901, 5451, 0), new WorldPoint(2903, 5450, 0), new WorldPoint(2902, 5453, 0), new WorldPoint(2908, 5456, 0), new WorldPoint(2913, 5454, 0)};

    public static boolean isAutumnElemental(NPC npc) {
        return npc.getId() >= 5802 && npc.getId() <= 5807;
    }

    public boolean correctPosition(NPC[] npcs, int runTileIndex) {
        try {
            switch (runTileIndex) {
                case 0: {
                    return true;
                }
                case 1: {
                    if (npcs[0].getOrientation() != 512 || npcs[0].getWorldLocation().getX() >= 2906) break;
                    return true;
                }
                case 2: {
                    if (npcs[0].getOrientation() != 1536 || npcs[0].getWorldLocation().getX() >= 2907 || npcs[0].getWorldLocation().getX() <= 2904) break;
                    return true;
                }
                case 3: {
                    if (npcs[1].getOrientation() != 0 || npcs[1].getWorldLocation().getY() >= 5454) break;
                    return true;
                }
                case 4: {
                    if (npcs[1].getOrientation() != 1024 || npcs[1].getWorldLocation().getY() <= 5451 || npcs[2].getOrientation() != 1536 || npcs[2].getWorldLocation().getX() >= 2903 || npcs[2].getWorldLocation().getX() <= 2900) break;
                    return true;
                }
                case 5: {
                    if (npcs[3].getWorldLocation().getY() <= 5453 && (npcs[3].getWorldLocation().getY() <= 5450 || npcs[3].getWorldLocation().getX() < 2905)) break;
                    return true;
                }
                case 6: {
                    if (npcs[3].getWorldLocation().getX() < 2904 && npcs[3].getWorldLocation().getY() <= 5453 || npcs[4].getOrientation() != 1536 && npcs[4].getWorldLocation().getX() >= 2905) break;
                    return true;
                }
                case 7: {
                    if (npcs[5].getOrientation() != 1536 || npcs[5].getWorldLocation().getX() >= 2914 || npcs[5].getWorldLocation().getX() <= 2910) break;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

