/*
 * Decompiled with CFR 0.152.
 */
package com.animationtransmog.effect;

import com.animationtransmog.AnimationTypes;
import com.animationtransmog.effect.Animation;
import com.animationtransmog.effect.Effect;
import com.animationtransmog.effect.GFX;
import com.animationtransmog.effect.Sound;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.runelite.api.Actor;
import net.runelite.api.ActorSpotAnim;
import net.runelite.api.Client;
import net.runelite.api.IterableHashTable;
import net.runelite.api.coords.WorldPoint;

public class EffectController {
    AnimationTypes animationTypes;
    HashMap<String, String> settings;
    List<Integer> regionBlacklist;
    List<String> regionBlacklistAnimations;
    HashMap<String, Effect> effects;
    private int customEffectLength = 0;
    private int customEffectLengthTimer = 0;
    private List<Integer> customEffectSpotAnimBlockList;
    private int customAnimationID = -1;
    private int customAnimationFrame = 0;
    private int customAnimationStartFrame = 0;
    private int customAnimationEndFrame = -1;
    private int customGfxID = -1;
    private int customGfxFrame = 0;
    private int customGfxStartFrame = 0;
    private int customGfxEndFrame = -1;
    private int customSoundID = -1;
    private int customSoundFrameDelay = 0;
    private WorldPoint effectLocation = null;
    private boolean isPlaying = false;
    private boolean isReadyToPlay = false;
    private String playingAnimationType = "";
    public Actor actor = null;
    public Client client = null;

    public EffectController(AnimationTypes animationTypes, HashMap<String, String> settings) {
        this.animationTypes = animationTypes;
        this.settings = settings;
        this.regionBlacklist = new ArrayList<Integer>();
        this.regionBlacklistAnimations = new ArrayList<String>();
        this.regionBlacklist.add(14164);
        this.regionBlacklist.add(14676);
        this.regionBlacklist.add(15188);
        this.regionBlacklist.add(15444);
        this.regionBlacklist.add(15700);
        this.regionBlacklist.add(15955);
        this.regionBlacklist.add(13906);
        this.regionBlacklist.add(14162);
        this.regionBlacklist.add(14674);
        this.regionBlacklist.add(15186);
        this.regionBlacklist.add(15698);
        this.regionBlacklist.add(15954);
        this.regionBlacklist.add(15953);
        this.regionBlacklist.add(14160);
        this.regionBlacklist.add(14672);
        this.regionBlacklist.add(15184);
        this.regionBlacklist.add(15696);
        this.regionBlacklistAnimations.add("Teleport");
        this.effects = new HashMap();
        this.effects.put("Hail Zamorak", new Effect(1500, 246, 0, 17, 0, 6, -1, 0, 150));
        this.effects.put("Praise Saradomin", new Effect(1500, 247, 0, 17, 0, 6, -1, 0, 150));
        this.effects.put("Ancient Disciple", new Effect(1500, 332, 0, 17, 0, 6, -1, 0, 150));
        this.effects.put("Glitch", new Effect(7040, 482, 0, 12, 0, 48, -1, 0, 150));
        this.effects.put("Pommel Smash", new Effect(9131, 559, 0, 35, 0, 10, -1, 0, 150));
        this.effects.put("???", new Effect(9286, -1, 0, 31, 0, 0, -1, 0, 150));
        this.effects.put("Darkness Ascends", new Effect(3945, 1577, 0, 12, 0, 57, -1, 0, 150));
        this.effects.put("2010 Vibes", new Effect(3945, 56, 0, 12, 0, 31, -1, 0, 150));
        this.effects.put("Jad 2 OP", new Effect(836, 451, 0, 9, 0, 20, -1, 0, 150));
        this.effects.put("Arcane Chop", new Effect(6298, 1063, 0, 159, 0, 40, -1, 0, -1));
        this.effects.put("Arcane Mine", new Effect(4411, 739, 0, 45, 15, 35, -1, 0, -1));
        this.effects.put("Smooth Scatter", new Effect(7533, 1103, 0, 32, 0, 32, -1, 0, -1));
        this.effects.put("Brutal", new Effect(9544, 1103, 0, 13, 0, 32, -1, 0, -1));
        this.effects.put("Blast Mine", new Effect(2107, 659, 0, 16, 0, 16, 163, 0, -1));
        this.effects.put("Dig", new Effect(830, -1, 0, 7, 0, 0, -1, 0, -1));
        this.effects.put("Headbang", new Effect(2108, -1, 0, 48, 0, 0, -1, 0, -1));
        this.effects.put("Plank", new Effect(837, -1, 0, 4, 0, 0, -1, 0, 200));
        this.customEffectSpotAnimBlockList = new ArrayList<Integer>();
    }

    public void setPlayer(Actor actor, Client client) {
        this.actor = actor;
        this.client = client;
    }

    public void setSettings(HashMap<String, String> settings) {
        this.settings = settings;
    }

    public void onChange() {
        String currentAnimationType = this.animationTypes.getAnimationType(this.actor.getAnimation());
        List<Integer> currentAnimationTypeSpotAnimIDs = this.animationTypes.getAnimationTypeSpotAnimIds(currentAnimationType);
        if (currentAnimationType == null) {
            return;
        }
        int[] regionIDs = this.client.getMapRegions();
        if (!Collections.disjoint(this.regionBlacklist, Arrays.stream(regionIDs).boxed().collect(Collectors.toList())) && this.regionBlacklistAnimations.contains(currentAnimationType)) {
            return;
        }
        if (this.isPlaying && this.playingAnimationType.equals(currentAnimationType)) {
            return;
        }
        this.setEffect(currentAnimationType, currentAnimationTypeSpotAnimIDs);
    }

    void setEffect(String currentAnimationType, List<Integer> currentAnimationTypeSpotAnimIDs) {
        String configOption = this.settings.get(currentAnimationType);
        if (configOption.equals("Default")) {
            return;
        }
        Effect effect = this.getEffect(configOption);
        if (effect == null) {
            return;
        }
        this.resetController();
        Animation newAnimation = effect.animation;
        GFX newGfx = effect.gfx;
        Sound newSound = effect.sound;
        this.customEffectLength = effect.length;
        if (currentAnimationTypeSpotAnimIDs.size() > 0) {
            this.customEffectSpotAnimBlockList = currentAnimationTypeSpotAnimIDs;
        }
        this.customAnimationID = newAnimation.animationId;
        this.customAnimationStartFrame = newAnimation.startFrame;
        this.customAnimationEndFrame = newAnimation.endFrame;
        if (newGfx.gfxId != -1) {
            this.customGfxID = newGfx.gfxId;
            this.customGfxStartFrame = newGfx.startFrame;
            this.customGfxEndFrame = newGfx.endFrame;
        }
        if (newSound.soundId != -1) {
            this.customSoundID = newSound.soundId;
            this.customSoundFrameDelay = newSound.delayFrame;
        }
        this.isReadyToPlay = true;
        this.playingAnimationType = currentAnimationType;
    }

    public void onBeforeRender() {
        if (!this.isPlaying) {
            if (this.isReadyToPlay) {
                this.playEffect();
            }
            return;
        }
        if (this.customEffectLength != -1 && this.customEffectLengthTimer >= this.customEffectLength || this.customEffectLength == -1 && this.customAnimationFrame >= this.customAnimationEndFrame || !this.effectLocation.equals((Object)this.actor.getWorldLocation())) {
            this.resetController();
            return;
        }
        int currentAnimationID = this.actor.getAnimation();
        if (this.customAnimationID != -1) {
            if (currentAnimationID != this.customAnimationID) {
                this.actor.setAnimation(this.customAnimationID);
                this.actor.setAnimationFrame(this.customAnimationFrame);
            }
            if (currentAnimationID == this.customAnimationID) {
                if (this.customAnimationFrame > this.customAnimationEndFrame) {
                    this.actor.setAnimationFrame(this.customAnimationEndFrame);
                }
                this.customAnimationFrame = this.actor.getAnimationFrame();
            }
        }
        IterableHashTable spotAnims = this.actor.getSpotAnims();
        if (this.actor.hasSpotAnim(this.customGfxID)) {
            if (this.customGfxFrame > this.customGfxEndFrame) {
                ((ActorSpotAnim)spotAnims.get((long)this.customGfxID)).setFrame(this.customGfxEndFrame);
            }
            this.customGfxFrame = ((ActorSpotAnim)spotAnims.get((long)this.customGfxID)).getFrame();
        }
        if (spotAnims != null && this.customEffectSpotAnimBlockList.size() > 0) {
            for (ActorSpotAnim spotAnim : spotAnims) {
                if (!this.customEffectSpotAnimBlockList.contains(spotAnim.getId())) continue;
                this.actor.removeSpotAnim((int)spotAnim.getHash());
            }
        }
    }

    public void updateTimer() {
        if (this.isPlaying) {
            ++this.customEffectLengthTimer;
        }
    }

    void resetController() {
        this.customEffectLength = 0;
        this.customEffectLengthTimer = 0;
        if (this.customEffectSpotAnimBlockList.size() > 0) {
            this.customEffectSpotAnimBlockList = new ArrayList<Integer>();
        }
        this.customAnimationFrame = 0;
        this.customAnimationStartFrame = 0;
        this.customAnimationEndFrame = -1;
        if (this.actor.getAnimation() == this.customAnimationID) {
            this.actor.setAnimation(-1);
        }
        this.customAnimationID = -1;
        this.customGfxFrame = 0;
        this.customGfxStartFrame = 0;
        this.customGfxEndFrame = -1;
        if (this.actor.hasSpotAnim(this.customGfxID)) {
            this.actor.removeSpotAnim(this.customGfxID);
        }
        this.customGfxID = -1;
        this.customSoundID = -1;
        this.customSoundFrameDelay = 0;
        this.effectLocation = null;
        this.isPlaying = false;
        this.isReadyToPlay = false;
        this.playingAnimationType = "";
    }

    void playEffect() {
        this.actor.setAnimation(this.customAnimationID);
        this.actor.setAnimationFrame(this.customAnimationStartFrame);
        if (this.customGfxID != -1) {
            this.actor.createSpotAnim(this.customGfxID, this.customGfxID, 0, 0);
            ((ActorSpotAnim)this.actor.getSpotAnims().get((long)this.customGfxID)).setFrame(this.customGfxStartFrame);
        }
        if (this.customSoundID != -1) {
            int sceneX = this.actor.getLocalLocation().getSceneX();
            int sceneY = this.actor.getLocalLocation().getSceneY();
            this.client.playSoundEffect(this.customSoundID, sceneX, sceneY, 1, this.customSoundFrameDelay);
        }
        this.effectLocation = this.actor.getWorldLocation();
        this.isPlaying = true;
        this.isReadyToPlay = false;
    }

    Effect getEffect(String effectName) {
        return this.effects.get(effectName);
    }
}

