/*
 * Decompiled with CFR 0.152.
 */
package com.animationtransmog.effect;

import com.animationtransmog.config.AnimationTransmogConfigManager;
import net.runelite.api.Actor;
import net.runelite.api.ActorSpotAnim;
import net.runelite.api.Client;

public class AnimationPlayerController {
    AnimationTransmogConfigManager configManager;
    private int selectedAnimationId = -1;
    private int selectedGFXId = -1;
    public Actor actor = null;
    public Client client = null;

    public AnimationPlayerController(AnimationTransmogConfigManager configManager) {
        this.configManager = configManager;
    }

    public void setPlayer(Actor actor, Client client) {
        this.actor = actor;
        this.client = client;
    }

    public void update() {
        int tempAnimationId = this.configManager.getAnimationPlayerOption("SelectedAnimation");
        int tempAnimationFrame = this.configManager.getAnimationPlayerOption("SelectedAnimationFrame");
        if (tempAnimationId == -1) {
            tempAnimationFrame = 0;
        }
        int tempGFXId = this.configManager.getAnimationPlayerOption("SelectedGFX");
        int tempGFXFrame = this.configManager.getAnimationPlayerOption("SelectedGFXFrame");
        int tempGFXHeight = this.configManager.getAnimationPlayerOption("SelectedGFXHeight");
        if (tempGFXId == -1) {
            tempGFXFrame = 0;
        }
        if (tempAnimationId == -1 && tempGFXId == -1) {
            return;
        }
        int currentAnimation = this.actor.getAnimation();
        if (currentAnimation == -1 && this.actor.getAnimationFrame() != 0) {
            this.actor.setAnimationFrame(0);
        }
        if (tempAnimationFrame != -1) {
            this.actor.setAnimationFrame(tempAnimationFrame);
        }
        if (tempAnimationId != this.selectedAnimationId || currentAnimation == -1) {
            this.actor.setAnimation(tempAnimationId);
        }
        if (this.actor.hasSpotAnim(this.selectedGFXId)) {
            if (tempGFXFrame != -1) {
                ((ActorSpotAnim)this.actor.getSpotAnims().get((long)this.selectedGFXId)).setFrame(tempGFXFrame);
            }
        } else {
            this.actor.createSpotAnim(tempGFXId, tempGFXId, tempGFXHeight, 0);
        }
        this.selectedAnimationId = tempAnimationId;
        this.selectedGFXId = tempGFXId;
    }
}

